package ru.yandex.iex.proxy.images;

import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

import org.apache.http.HttpHost;

import ru.yandex.http.config.ImmutableHttpTargetConfig;
import ru.yandex.parser.config.ConfigException;

public class ImmutableZoraProxyClientConfig
    extends ImmutableHttpTargetConfig
    implements ZoraProxyClientConfig
{
    private static final int MIN_EXT_SIZE = 3;
    private static final int MAX_EXT_SIZE = 4;

    private final List<HttpHost> zoraHosts;
    private final double partToDownload;
    private final int maxCacheSize;
    private final long expirePeriod;

    public ImmutableZoraProxyClientConfig(
        final ZoraProxyClientConfig config)
        throws ConfigException
    {
        super(config);

        this.zoraHosts =
            Collections.unmodifiableList(new ArrayList<>(config.zoraHosts()));

        this.partToDownload = config.partToDownload();
        this.maxCacheSize = config.maxCacheSize();
        this.expirePeriod = config.expirePeriod();
    }

    @Override
    public List<HttpHost> zoraHosts() {
        return zoraHosts;
    }

    @Override
    public double partToDownload() {
        return partToDownload;
    }

    @Override
    public int maxCacheSize() {
        return maxCacheSize;
    }

    @Override
    public long expirePeriod() {
        return expirePeriod;
    }

    @SuppressWarnings("StringSplitter")
    public static boolean checkUrl(final URL url) {
        if (url.getFile() != null) {
            String[] split = url.getFile().split("\\.");
            if (split.length > 1) {
                String last = split[split.length - 1];
                if (last.length() >= MIN_EXT_SIZE
                    && last.length() <= MAX_EXT_SIZE)
                {
                    return true;
                }
            }
        }

        return false;
    }

    public HttpHost resolve(final String urlStr) throws MalformedURLException {
        URL url = new URL(urlStr);
        if (checkUrl(url)) {
            int index =
                Math.abs(url.getHost().hashCode() % zoraHosts.size());
            return zoraHosts.get(index);
        }

        return null;
    }
}
