package ru.yandex.iex.proxy.images;

import java.util.Collections;
import java.util.List;

import org.apache.http.HttpHost;

import ru.yandex.http.config.HttpTargetConfigDefaults;

public class ZoraProxyClientConfigDefaults
    extends HttpTargetConfigDefaults
    implements ZoraProxyClientConfig
{
    public static final ZoraProxyClientConfigDefaults INSTANCE
        = new ZoraProxyClientConfigDefaults();
    private static final int DEFAULT_CONNECTIONS = 100;
    private static final int MAX_CACHE_SIZE = 10000000;
    private static final int DEFAULT_EXPIRE_SECONDS = 60 * 60 * 24;

    @Override
    public List<HttpHost> zoraHosts() {
        return Collections.emptyList();
    }

    @Override
    public double partToDownload() {
        return -1;
    }

    @Override
    public int connections() {
        return DEFAULT_CONNECTIONS;
    }

    @Override
    public int maxCacheSize() {
        return MAX_CACHE_SIZE;
    }

    @Override
    public long expirePeriod() {
        return DEFAULT_EXPIRE_SECONDS;
    }
}
