package ru.yandex.iex.proxy.images;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;

import org.apache.http.HttpEntity;
import org.apache.http.HttpException;
import org.apache.http.protocol.HttpContext;

import ru.yandex.json.async.consumer.AbstractJsonAsyncDomConsumer;
import ru.yandex.json.xpath.JsonUnexpectedTokenException;
import ru.yandex.json.xpath.ValueUtils;

public class ZoraProxyResultConsumer
    extends AbstractJsonAsyncDomConsumer<List<Image>>
{
    public ZoraProxyResultConsumer(
        final HttpEntity entity)
        throws HttpException
    {
        super(entity);
    }

    private Image buildImage(
        final Object value)
        throws JsonUnexpectedTokenException
    {
        Map<?, ?> map = ValueUtils.asMap(value);

        return new Image(
            ValueUtils.asInt(map.get("height")),
            ValueUtils.asInt(map.get("width")));
    }

    @Override
    protected List<Image> buildResult(
        final HttpContext context,
        final Object value)
        throws Exception
    {
        if (value instanceof List) {
            List<?> items = (List<?>) value;
            List<Image> result = new ArrayList<>(items.size());
            for (Object item: items) {
                result.add(buildImage(item));
            }

            return result;
        } else {
            return Collections.singletonList(buildImage(value));
        }
    }
}
