package ru.yandex.iex.proxy.images;

import java.util.List;

import org.apache.http.HttpException;
import org.apache.http.HttpResponse;
import org.apache.http.nio.protocol.HttpAsyncRequestProducer;

import ru.yandex.http.util.HttpStatusPredicates;
import ru.yandex.http.util.nio.HttpAsyncResponseConsumerFactory;
import ru.yandex.http.util.nio.StatusCheckAsyncResponseConsumerFactory;

public class ZoraProxyResultConsumerFactory
    implements HttpAsyncResponseConsumerFactory<List<Image>>
{
    public static final ZoraProxyResultConsumerFactory INSTANCE =
        new ZoraProxyResultConsumerFactory();
    public static final StatusCheckAsyncResponseConsumerFactory<List<Image>>
        OK = new StatusCheckAsyncResponseConsumerFactory<>(
        HttpStatusPredicates.OK,
        INSTANCE);

    protected ZoraProxyResultConsumerFactory() {
    }

    @Override
    public ZoraProxyResultConsumer create(
        final HttpAsyncRequestProducer producer,
        final HttpResponse response)
        throws HttpException
    {
        return new ZoraProxyResultConsumer(response.getEntity());
    }
}
