package ru.yandex.iex.proxy.kinopoisk;

import java.io.IOException;
import java.util.logging.Level;

import org.apache.http.HttpHeaders;
import org.apache.http.HttpHost;
import org.apache.http.concurrent.FutureCallback;
import org.apache.http.entity.ContentType;

import ru.yandex.http.proxy.ProxySession;
import ru.yandex.http.util.YandexHeaders;
import ru.yandex.http.util.nio.BasicAsyncRequestProducerGenerator;
import ru.yandex.http.util.nio.client.AsyncClient;
import ru.yandex.iex.proxy.IexProxy;
import ru.yandex.iex.proxy.eventtickethandler.EventCallback;
import ru.yandex.iex.proxy.eventtickethandler.EventTicketContext;
import ru.yandex.io.StringBuilderWriter; //import ru.yandex.json.async.consumer.JsonAsyncTypesafeDomConsumerFactory;
import ru.yandex.json.dom.JsonBadCastException;
import ru.yandex.json.dom.JsonList;
import ru.yandex.json.dom.JsonMap;
import ru.yandex.json.dom.JsonObject;
import ru.yandex.json.writer.JsonType;
import ru.yandex.json.writer.JsonWriter;

public class KinopoiskQlCallback extends EventCallback {
    public KinopoiskQlCallback(final EventCallback callback) {
        super(callback);
    }

    @Override
    public void act(final EventTicketContext context) {
        String title = String.valueOf(context.getOutputJson().get("title"));
        IexProxy iexProxy = context.iexProxy();
        ProxySession session = context.session();
        AsyncClient client = iexProxy.kinopoiskQlClient().adjust(context.session().context());
        HttpHost host =
            iexProxy.config().kinopoiskQlConfig().host();

        StringBuilderWriter sbw =
        new StringBuilderWriter(new StringBuilder(""));

        try (JsonWriter writer = new JsonWriter(sbw)) {
            writer.startObject();
            writer.key("operationName");
            writer.value("MatchingMovies");
            writer.key("variables");
            writer.startObject();
            writer.key("title");
            writer.value(title);
            writer.endObject();

            writer.key("query");
            String queryVal = "query MatchingMovies($title: String\u0021) { "
                + "matching {    movies(query: {type: FILM, titles: [$title]})"
                + "{      relevance      match      movie {        __typename "
                + "id        url        title {          russian         "
                + "original        }        rating {          kinopoisk {     "
                + "count            isActive            value          }      "
                + "}        ... on Film {          productionYear        }    "
                + "... on Video {          productionYear        }      }    }"
                + "}}";
            writer.value(queryVal);

            writer.endObject();
        } catch (IOException e) {
            session.logger().log(
                    Level.INFO,
                    "Exception while constructing kinopoisk request");
            callback.completed(null);
        }

        BasicAsyncRequestProducerGenerator generator =
            new BasicAsyncRequestProducerGenerator("/graphql", sbw.toString());
        generator.addHeader(
                YandexHeaders.X_YA_SERVICE_TICKET,
                iexProxy.kinopoiskTvm2Ticket());
        generator.addHeader(
                HttpHeaders.CONTENT_TYPE,
                ContentType.APPLICATION_JSON.toString());
        generator.addHeader(
                HttpHeaders.ACCEPT,
                ContentType.APPLICATION_JSON.toString());
        session.logger().info("Temp ignore kinopoisk requests " + sbw.toString());
        callback.execute(context);
        // session.logger().info("Executing kinopoisk request " + sbw.toString());
        // client.execute(
        //    host,
        //    generator,
        //    JsonAsyncTypesafeDomConsumerFactory.OK,
        //    context.session()
        //        .listener().createContextGeneratorFor(client),
        //    new KinoposikCallback(callback, context));
    }

    @Override
    public void execute(final EventTicketContext context) {
        this.context = context;
        act(context);
    }

    private static class KinoposikCallback
        implements FutureCallback<JsonObject>
    {
        private final EventCallback callback;
        private final EventTicketContext context;

        KinoposikCallback(
                final EventCallback callback,
                final EventTicketContext context)
        {
            this.callback = callback;
            this.context = context;
        }

        @Override
        public void cancelled() {
            context.session().logger().
                info("KinoposikQlCallback cancelled");
            callback.execute(context);
        }

        @Override
        public void failed(final Exception e) {
            context.session().logger().
                info("KinoposikQlCallback failed");
            callback.execute(context);
        }

        @Override
        public void completed(final JsonObject result) {
            try {
                context.session().logger().info("kinopoisk returned:"
                        + JsonType.NORMAL.toString(result));
                JsonMap data = result.asMap().get("data").asMap();
                JsonList movies = data.get("matching").asMap().get("movies").asList();
                if (movies.size() > 0) {
                    JsonObject movie = movies.get(0).asMap().get("movie");
                    String url = movie.get("url").asString();
                    context.session().logger().info("kinopoisk_url: " + url);
                    String originalTitle = movie.get("title").asMap().get("original").asString();
                    context.session().logger().info("original_title: " + originalTitle);
                    String rating = movie.get("rating").asMap().
                        get("kinopoisk").asMap().get("value").asString();
                    context.session().logger().info("rating: " + rating);
                    context.getOutputJson().put("kinopoisk_url", url);
                    context.getOutputJson().put("original_title", originalTitle);
                    context.getOutputJson().put("rating", rating);
                }
                callback.execute(context);
            } catch (JsonBadCastException e) {
                context.session().logger().
                    info("JsonBadCastException in KinoposikCallback completed ");
                callback.execute(context);
            } catch (Exception e) {
                context.session().logger().
                    info("catch Exception in KinoposikCallback completed, ignore");
                callback.execute(context);
            }
        }
    }
}
