package ru.yandex.iex.proxy.mboeventticketextractor;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;

import ru.yandex.iex.proxy.mboeventticketextractor.enums.KeysName;
/*
 https://wiki.yandex-team.ru/ps/iex/results-new/event-reservation/
*/

public abstract class AbstractExtractor {
    protected Map<?, ?> in;

    public AbstractExtractor(final Map<String, Object> in) {
        Object l = readList(in);
        if (l instanceof List && !((List) l).isEmpty()) {
            l = ((List) l).get(0);
        }
        if (l instanceof Map) {
            this.in = (Map<?, ?>) l;
        } else {
            this.in = in;
        }
    }

    protected Object readList(final Map<String, Object> inJson) {
        return inJson.get(KeysName.MOVIE);
    }

    abstract void putSeats(final Map<String, Object> out);

    abstract void putDomain(final Map<String, Object> out, final String domain);

    void putWidgetSubtype(final Map<String, Object> out) {
        out.put(KeysName.WIDGET_SUBTYPE, "cinema");
    }

    void putOrigin(final Map<String, Object> out) {
        out.put(KeysName.ORIGIN, "mbo_extractor");
    }

    abstract void putPrintParts(final Map<String, Object> out);

    abstract void putSpecialParts(final Map<String, Object> out);

    void putRawData(final Map<String, Object> out) {
        out.put(KeysName.RAW_DATA, in);
    }

    abstract void putLocation(final Map<String, Object> out);

    abstract void putTitle(final Map<String, Object> out);

    abstract void putNumSeats(final Map<String, Object> out);

    abstract void putDate(final Map<String, Object> out);

    abstract void putDateTs(final Map<String, Object> out);

    abstract void putDateTz(final Map<String, Object> out);

    abstract void putUrl(final Map<String, Object> out);

    abstract void putReservationNumber(final Map<String, Object> out);

    public void putOrganizer(final Map<String, Object> out) {
    }

    public void putCancelReservationUrl(final Map<String, Object> out) {
    }

    public void putAnotherDate(final Map<String, Object> out) {
    }

    protected void putIfContains(
        final String keyOut,
        final String keyIn,
        final Map<String, Object> out)
    {
        Object v = in.get(keyIn);
        if (v != null) {
            out.put(keyOut, v);
        }
    }

    protected void putIfContainsAndSplit(
        final String keyOut,
        final String keyIn,
        final Map<String, Object> out)
    {
        Object v = in.get(keyIn);
        if (v instanceof String) {
            String ttosplit = (String) v;
            String[] texts = ttosplit.split("\\s");
            if (texts.length > 1) {
                out.put(keyOut, new ArrayList<String>(Arrays.asList(texts)));
            } else {
                out.put(keyOut, v);
            }
        }
    }
}
