package ru.yandex.iex.proxy.mboeventticketextractor;

import java.util.HashMap;
import java.util.Map;

import ru.yandex.iex.proxy.mboeventticketextractor.enums.Domains;

public class MboEventTicketExtractor {
    private Map<String, Object> output = new HashMap<>();

    public MboEventTicketExtractor(
        final Map<String, Object> in,
        final String domain)
    {
        AbstractMboExtractorFactory builder = initializeFactory(domain);
        AbstractExtractor extractor = builder.createMboExtractor(in);
        extractor.putWidgetSubtype(output);
        extractor.putOrigin(output);
        extractor.putDomain(output, domain);
        extractor.putPrintParts(output);
        extractor.putDate(output);
        extractor.putDateTs(output);
        extractor.putDateTz(output);
        extractor.putSpecialParts(output);
        extractor.putTitle(output);
        extractor.putLocation(output);
        extractor.putNumSeats(output);
        extractor.putSeats(output);
        //extractor.putRawData(output);
        extractor.putReservationNumber(output);
        extractor.putUrl(output);
        extractor.putCancelReservationUrl(output);
        extractor.putOrganizer(output);
        extractor.putAnotherDate(output);
    }

    public Map<String, Object> getOutput() {
        return output;
    }

    private AbstractMboExtractorFactory initializeFactory(
        final String domain)
    {
        AbstractMboExtractorFactory res;
        switch (getTypeByDomain(domain)) {
            case PONOMINALU:
                res = new PonominaluExtractorFactory();
                break;
            case TICKETLAND:
                res = new TicketlandExtractorFactory();
                break;
            case TIMEPAD:
                res = new TimepadExtractorFactory();
                break;
            default:
                res = new NullFactory();
        }
        return res;
    }

    private Domains getTypeByDomain(final String url) {
        Domains res = Domains.UKNOWN;
        if (url.endsWith("ponominalu.ru")) {
            res = Domains.PONOMINALU;
        } else if (url.endsWith("ticketland.ru")) {
            res = Domains.TICKETLAND;
        } else if (url.endsWith("timepad.ru")) {
            res = Domains.TIMEPAD;
        }
        return res;
    }
}
