package ru.yandex.iex.proxy.mboeventticketextractor;

import java.util.List;
import java.util.Map;

import ru.yandex.iex.proxy.eventtickethandler.EventCallback;
import ru.yandex.iex.proxy.eventtickethandler.EventParser;
import ru.yandex.iex.proxy.eventtickethandler.EventTicketContext;
import ru.yandex.iex.proxy.eventtickethandler.EventTicketHandler;

public class MboMovieCallback extends EventCallback {
    private EventParser cinemaParser = new MboMovieInfoParser();

    public MboMovieCallback(final EventCallback callback) {
        super(callback);
    }

    @Override
    public void act(final EventTicketContext context) {
        Map<String, Object> in = context.getInputJson();
        Map<String, Object> out = context.getOutputJson();
        Object lmovie = in.get(EventTicketHandler.MOVIE);
        if (lmovie != null) {
            if (lmovie instanceof List) {
                for (Object x : (List) lmovie) {
                    cinemaParser.parse(x, out);
                }
            }
            out.put(
                EventTicketHandler.WIDGET_SUBTYPE,
                EventTicketHandler.CINEMA);
            out.put(EventTicketHandler.ORIGIN, EventTicketHandler.MOVIE);
            out.put(EventTicketHandler.DOMAIN, context.getDomain());
        }
    }
}
