package ru.yandex.iex.proxy.mboeventticketextractor;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;

import ru.yandex.iex.proxy.XRegexpUtils;
import ru.yandex.iex.proxy.eventtickethandler.EventParser;
import ru.yandex.iex.proxy.eventtickethandler.EventTicketHandler;

public class MboMovieInfoParser extends EventParser {
    public void parse(
        final Object in,
        final Map<String, Object> out)
    {
        if (in instanceof Map) {
            Map<?, ?> mp = (Map) in;
            Object seats = mp.get(EventTicketHandler.SEATS);
            if (seats instanceof String) {
                Object seatsValue = parseSeatsStructure((String) seats);
                out.put(EventTicketHandler.SEATS, seatsValue);
            }
            Map<String, Object> location = new HashMap<>();
            Object place = mp.get("place");
            if (place instanceof String) {
                location.put(EventTicketHandler.NAME, place);
            }
            Object urls = mp.get("url_eticket");
            if (urls instanceof String) {
                out.put("url", urls);
            }
            if (!location.isEmpty()) {
                out.put(EventTicketHandler.LOCATION, location);
            }
        }
    }

    @Override
    protected ArrayList<String> parseRowsByRegexp(final String s) {
        return XRegexpUtils.getRowsMovieSpec(s);
    }

    @Override
    protected ArrayList<String> parseSeatsByRegexp(final String s) {
        return XRegexpUtils.getSeatsMovieSpec(s);
    }
}
