package ru.yandex.iex.proxy.mboeventticketextractor;

import java.util.HashMap;
import java.util.Map;

import ru.yandex.iex.proxy.mboeventticketextractor.enums.KeysName;

public class PonominaluExtractor extends AbstractExtractor {
    public static final String DATE = "date";

    PonominaluExtractor(final Map<String, Object> in) {
        super(in);
    }

    public void putSeats(final Map<String, Object> out) {
    }

    public void putPrintParts(final Map<String, Object> out) {
    }

    public void putSpecialParts(final Map<String, Object> out) {
    }

    public void putLocation(final Map<String, Object> out) {
        Object loc = in.get("place");
        if (loc instanceof String) {
            String loct = (String) loc;
            int id = loct.indexOf(',');
            String name = loct.substring(0, id);
            String address = loct.substring(id);
            Map<String, Object> location = new HashMap<>();
            location.put("name", name);
            location.put("address", address);
            out.put(KeysName.LOCATION, location);
        }
    }

    public void putTitle(final Map<String, Object> out) {
        putIfContains(KeysName.TITLE, "movie", out);
    }

    public void putNumSeats(final Map<String, Object> out) {
    }

    public void putDate(final Map<String, Object> out) {
        putIfContains(KeysName.START_DATE, DATE, out);
    }

    public void putDateTs(final Map<String, Object> out) {
        //putIfContains(KeysName.START_DATE + "_ts", DATE, out);
    }

    public void putDateTz(final Map<String, Object> out) {
        putIfContains(KeysName.START_DATE + "_tz", DATE, out);
    }

    public void putDomain(final Map<String, Object> out, final String domain) {
        out.put(KeysName.DOMAIN, domain);
    }

    public void putUrl(final Map<String, Object> out) {
        putIfContainsAndSplit(KeysName.URL, "url_eticket", out);
    }

    public void putReservationNumber(final Map<String, Object> out) {
        putIfContains(KeysName.RESERVATION_NUMBER, "order_num", out);
    }
}
