package ru.yandex.iex.proxy.mboeventticketextractor;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;

import ru.yandex.iex.proxy.XRegexpUtils;
import ru.yandex.iex.proxy.XStrAlgo;
import ru.yandex.iex.proxy.XTools;
import ru.yandex.iex.proxy.eventtickethandler.EventParser;
import ru.yandex.iex.proxy.mboeventticketextractor.enums.KeysName;

public class TicketlandExtractor extends AbstractExtractor {
    public static final String DATE = "date";

    TicketlandExtractor(final Map<String, Object> in) {
        super(in);
    }

    private static class SeatsParser extends EventParser {
        @Override
        public void parse(final Object in, final Map<String, Object> out) {
            if (in instanceof Map) {
                Map<?, ?> mp = (Map) in;
                Object seats = mp.get(KeysName.SEATS);
                if (seats instanceof String) {
                    Object seatsValue = parseSeatsStructure((String) seats);
                    out.put(KeysName.SEATS, seatsValue);
                }
            }
        }

        @Override
        protected ArrayList<String> parseRowsByRegexp(final String s) {
            return XRegexpUtils.getRowsMovieSpec(s);
        }

        @Override
        protected ArrayList<String> parseSeatsByRegexp(final String s) {
            return XRegexpUtils.getSeatsMovieSpec(s);
        }
    }

    public void putSeats(final Map<String, Object> out) {
        (new SeatsParser()).parse(in, out);
    }

    public void putPrintParts(final Map<String, Object> out) {
    }

    public void putSpecialParts(final Map<String, Object> out) {
    }

    public void putLocation(final Map<String, Object> out) {
        Object loc = in.get("place");
        if (loc instanceof String) {
            String loct = (String) loc;
            int zValue = XTools.getMinimumNotNull(XStrAlgo.zFunction(loct));
            if (zValue >= 0 && zValue < loct.length()) {
                loct = loct.substring(0, zValue);
            }
            Map<String, Object> location = new HashMap<>();
            location.put("name", loct);
            out.put(KeysName.LOCATION, location);
        }
    }

    public void putTitle(final Map<String, Object> out) {
        putIfContains(KeysName.TITLE, "movie", out);
    }

    public void putNumSeats(final Map<String, Object> out) {
    }

    public void putDate(final Map<String, Object> out) {
        putIfContains(KeysName.START_DATE, DATE, out);
    }

    public void putDateTs(final Map<String, Object> out) {
        //putIfContains(KeysName.START_DATE + "_ts", DATE, out);
    }

    public void putDateTz(final Map<String, Object> out) {
        putIfContains(KeysName.START_DATE + "_tz", DATE, out);
    }

    public void putDomain(final Map<String, Object> out, final String domain) {
        out.put(KeysName.DOMAIN, domain);
    }

    public void putUrl(final Map<String, Object> out) {
        putIfContainsAndSplit(KeysName.URL, "url_eticket", out);
    }

    public void putReservationNumber(final Map<String, Object> out) {
        putIfContains(KeysName.RESERVATION_NUMBER, "order_num", out);
    }
}
