package ru.yandex.iex.proxy.mboeventticketextractor;

import java.util.Map;

import ru.yandex.iex.proxy.mboeventticketextractor.enums.KeysName;

public class TimepadExtractor extends AbstractExtractor {
    public static final String CALENDAR_URL = "calendar_url";

    TimepadExtractor(final Map<String, Object> in) {
        super(in);
    }

    @Override
    protected Object readList(final Map<String, Object> inJson) {
        return inJson.get("timepad");
    }

    @Override
    void putWidgetSubtype(final Map<String, Object> out) {
        out.put(KeysName.WIDGET_SUBTYPE, "calendar");
    }

    public void putSeats(final Map<String, Object> out) {
    }

    public void putPrintParts(final Map<String, Object> out) {
    }

    public void putSpecialParts(final Map<String, Object> out) {
    }

    public void putLocation(final Map<String, Object> out) {
    }

    public void putTitle(final Map<String, Object> out) {
        putIfContains(KeysName.TITLE, "event", out);
    }

    public void putNumSeats(final Map<String, Object> out) {
    }

    public void putDate(final Map<String, Object> out) {
        putIfContains(KeysName.START_DATE, "date_start", out);
    }

    public void putDateTs(final Map<String, Object> out) {
        //putIfContains(KeysName.START_DATE + "_ts", DATE, out);
    }

    public void putDateTz(final Map<String, Object> out) {
       // putIfContains(KeysName.START_DATE + "_tz", DATE, out);
    }

    public void putDomain(final Map<String, Object> out, final String domain) {
        out.put(KeysName.DOMAIN, domain);
    }

    public void putUrl(final Map<String, Object> out) {
        putIfContainsAndSplit(CALENDAR_URL, CALENDAR_URL, out);
    }

    public void putReservationNumber(final Map<String, Object> out) {
        //putIfContains(KeysName.RESERVATION_NUMBER, "order_num", out);
    }

    @Override
    public void putOrganizer(final Map<String, Object> out) {
        putIfContains("organizer", "company", out);
    }

    @Override
    public void putCancelReservationUrl(final Map<String, Object> out) {
        putIfContains("cancel_reservation_url", "canceling_url", out);
    }

    @Override
    public void putAnotherDate(final Map<String, Object> out) {
        putIfContains("end_date", "date_end", out);
        //putIfContains("end_date_ts", "time_end", out);
        putIfContains("end_time", "time_end", out);
        putIfContains("start_time", "time_start", out);
    }
}
