package ru.yandex.iex.proxy.move;

import java.util.List;
import java.util.Map;

import ru.yandex.http.proxy.ProxySession;
import ru.yandex.iex.proxy.IexProxy;
import ru.yandex.iex.proxy.IndexationContext;
import ru.yandex.iex.proxy.xutils.spamreport.SendMailContext;

public class SpamContext implements SendMailContext {
    private final IndexationContext<UpdateDataHolder> context;

    public SpamContext(final IndexationContext<UpdateDataHolder> context) {
        this.context = context;
    }

    @Override
    public String subject() {
        if (iexProxy().alarmSoUser(prefix())) {
            return "ALARM<" + to() + ">: " + context.subject();
        } else {
            return context.subject();
        }
    }

    @Override
    public String to() {
        return context.userEmail().replaceAll("\n", " ");
    }

    @Override
    public String from() {
        return context.email();
    }

    @Override
    public long date() {
        return context.receivedDate();
    }

    @Override
    public String mid() {
        return context.mid();
    }

    @Override
    public String stid() {
        return context.stid();
    }

    @Override
    public long prefix() {
        return context.uidLong();
    }

    @Override
    public String msgId() {
        return "uid:" + prefix() + "/stid:" + stid();
    }

    @Override
    public IexProxy iexProxy() {
        return context.abstractContext().iexProxy();
    }

    @Override
    public ProxySession session() {
        return context.abstractContext().session();
    }

    @Override
    public List<Integer> types() {
        return context.types();
    }

    @Override
    public List<Map.Entry<String, String>> additionalHeaders() {
        return null;
    }

    @Override
    public Map<?, ?> json() {
        return context.headers();
    }
}
