package ru.yandex.iex.proxy.move;

import java.util.List;

import ru.yandex.client.so.shingler.AbstractShinglesMap;
import ru.yandex.client.so.shingler.ShinglersData;
import ru.yandex.client.so.shingler.config.ShinglerType;
import ru.yandex.iex.proxy.complaints.MailMessageContext;
import ru.yandex.iex.proxy.complaints.Sources;
import ru.yandex.iex.proxy.complaints.UserAction;
import ru.yandex.parser.mail.senders.SenderInfo;

// Holds information from one message
// Contains aggregation logic and lucene update generation
// If 2 updates containing same sender arrive in the same second,
// second wont be ignored
public class UpdateDataHolder {

    private final MailMessageContext context;
    private final String senderDomain;
    private final List<SenderInfo> senders;
    private long receivedDate;
    private long operationDate;
    private final String uid;
    private final Sources source;

    public UpdateDataHolder(
        final MailMessageContext msgContext,
        final String sourceDomain,
        final List<SenderInfo> senders,
        final Sources source)
    {
        context = msgContext;
        this.senderDomain = sourceDomain;
        this.senders = senders;
        this.source = source;
        operationDate = msgContext.actionDate();
        receivedDate = msgContext.messageDate();
        uid = msgContext.uid();
    }

    public UpdateDataHolder(
        final MailMessageContext msgContext,
        final String sourceDomain,
        final List<SenderInfo> senders)
    {
        this(msgContext, sourceDomain, senders, msgContext.source());
    }

    public MailMessageContext context() {
        return context;
    }

    public String uid() {
        return uid;
    }

    public String stid() {
        return context.stid();
    }

    public Boolean isSpam() {   // false means ham
        if (context.action() == null || context.action() != UserAction.SPAM && context.action() != UserAction.HAM) {
            return null;
        }
        return context.action() == UserAction.SPAM;
    }

    public List<SenderInfo> senders() {
        return senders;
    }

    public String senderDomain() {
        return senderDomain;
    }

    public long receivedDate() {
        return receivedDate;
    }

    public void setReceivedDate(final long receivedDate) {
        this.receivedDate = receivedDate;
    }

    public long operationDate() {
        return operationDate;
    }

    public void setOperationDate(final long operationDate) {
        this.operationDate = operationDate;
    }

    public Sources source() {
        return source;
    }

    public String queueId() {
        return context.queueId();
    }

    public ShinglersData shinglersData() {
        return context.shinglersData();
    }

    public AbstractShinglesMap<?> shinglerData(final ShinglerType shinglerType) {
        return context.shinglersData().get(shinglerType);
    }

    public boolean containsShinglerData(final ShinglerType shinglerType) {
        return context.shinglersData().containsKey(shinglerType) && context.shinglersData().get(shinglerType) != null;
    }

    public boolean isRetry() {
        return context.isRetry();
    }

    public UpdateDataHolder self() {
        return this;
    }
}
