package ru.yandex.iex.proxy.newshandler;

import java.util.HashMap;
import java.util.Map;

import org.apache.http.HttpException;
import org.apache.http.HttpStatus;

import ru.yandex.http.proxy.ProxySession;
import ru.yandex.iex.proxy.AbstractEntityContext;
import ru.yandex.iex.proxy.IexProxy;
import ru.yandex.iex.proxy.XJsonUtils;
import ru.yandex.json.writer.JsonType;
import ru.yandex.json.xpath.JsonUnexpectedTokenException;

public class NewsAllUrlContext extends AbstractEntityContext {
    public static final String SUBJECT = "subject";
    public static final String NEWS = "news";
    private Map<Object, Object> response = new HashMap<>();

    public NewsAllUrlContext(
        final IexProxy iexProxy,
        final ProxySession session,
        final Map<?, ?> json)
        throws HttpException, JsonUnexpectedTokenException
    {
        super(iexProxy, session, json);
        Object s = XJsonUtils.getNodeByPathOrNullEless(json, NEWS);
        if (s instanceof Map) {
            response.putAll((Map<?, ?>) s);
        }
        String subject = session.params().getOrNull(SUBJECT);
        String from = session.params().getOrNull("email");
        if (subject != null) {
            response.put(SUBJECT, subject);
        }
        if (from != null) {
            response.put("from", from);
        }
    }

    @Override
    public void response() {
        session.response(
            HttpStatus.SC_OK,
            JsonType.NORMAL.toString(response));
    }
}
