package ru.yandex.iex.proxy.newshandler;

import java.util.HashMap;
import java.util.Map;
import java.util.logging.Level;

import org.apache.http.HttpException;
import org.apache.http.HttpStatus;
import org.apache.http.concurrent.FutureCallback;

import ru.yandex.http.proxy.ProxySession;
import ru.yandex.iex.proxy.AbstractEntityContext;
import ru.yandex.iex.proxy.IexProxy;
import ru.yandex.iex.proxy.XJsonUtils;
import ru.yandex.iex.proxy.images.Image;
import ru.yandex.json.writer.JsonType;
import ru.yandex.json.xpath.JsonUnexpectedTokenException;
import ru.yandex.json.xpath.ValueUtils;

public class NewsContext extends AbstractEntityContext {
    public static final String SUBJECT = "subject";
    public static final String NEWS = "news";
    private static final String SELECTED_IMG = "selected_img";
    private Map<Object, Object> response = new HashMap<>();
    private Map<?, ?> source = null;
    private Image best = null;

    public NewsContext(
        final IexProxy iexProxy,
        final ProxySession session,
        final Map<?, ?> json)
        throws HttpException, JsonUnexpectedTokenException
    {
        super(iexProxy, session, json);

        Object s = XJsonUtils.getNodeByPathOrNullEless(json, NEWS);
        if (s instanceof Map) {
            source = (Map<?, ?>) s;
            response.putAll(source);
            response.remove("all_imgs");

            Object selImgObj = source.get(SELECTED_IMG);
            if (selImgObj != null) {
                try {
                    Map<?, ?> selImgMap = ValueUtils.asMap(selImgObj);
                    String url =
                        ValueUtils.asStringOrNull(selImgMap.get("src"));
                    int width = ValueUtils.asInt(selImgMap.get("width"));
                    int height = ValueUtils.asInt(selImgMap.get("height"));
                    best = new Image(height, width);
                    best.url(url);
                } catch (JsonUnexpectedTokenException jue) {
                    session.logger().log(
                        Level.WARNING,
                        "Bad selected_img entry", jue);
                    best = new Image(-1, -1);
                }
            } else {
                best = new Image(-1, -1);
            }
        }
        String subject = session.params().getOrNull(SUBJECT);
        String from = session.params().getOrNull("email");
        if (subject != null) {
            response.put(SUBJECT, subject);
        }
        if (from != null) {
            response.put("from", from);
        }
    }

    @Override
    public void response() {
        if (best == null) {
            session.logger().info("Best is null");
            session.response(
                HttpStatus.SC_OK,
                JsonType.NORMAL.toString(response));
        } else {
            iexProxy.imagesFetcher().fetch(
                source,
                session,
                new BestImageSelectCallback());
        }
    }

    private final class BestImageSelectCallback
        implements FutureCallback<Image>
    {
        @Override
        public void completed(final Image image) {
            StringBuilder logInfo = new StringBuilder();
            logInfo.append("Images fetch complete with ");
            logInfo.append(String.valueOf(image));
            logInfo.append(" , best is ");
            logInfo.append(String.valueOf(best));

            session.logger().info(logInfo.toString());
            if (image != null
                && image.decent()
                && image.compareTo(best) > 0
                && image.url() != null)
            {
                iexProxy.mailImagesDownloaded(1);

                session.logger().info(
                    "Downloaded " + image.toString()
                        + " is better than selected " + best.toString());
                response.put(SELECTED_IMG, image.asMap());
            } else {
                iexProxy.mailImagesDownloaded(0);
            }

            session.response(
                HttpStatus.SC_OK,
                JsonType.NORMAL.toString(response));
        }

        @Override
        public void failed(final Exception e) {
            session.logger().log(
                Level.WARNING,
                "Best Image fetch failed",
                e);

            iexProxy.imageDownloadFailed();
            session.response(
                HttpStatus.SC_OK,
                JsonType.NORMAL.toString(response));
        }

        @Override
        public void cancelled() {
            session.response(
                HttpStatus.SC_OK,
                JsonType.NORMAL.toString(response));
        }
    }
}
