package ru.yandex.iex.proxy.newshandler;

import java.util.Map;

import org.apache.http.HttpException;

import ru.yandex.http.proxy.ProxySession;
import ru.yandex.http.util.BadRequestException;
import ru.yandex.iex.proxy.AbstractEntityHandler;
import ru.yandex.iex.proxy.IexProxy;
import ru.yandex.json.xpath.JsonUnexpectedTokenException;

public class NewsHandler extends AbstractEntityHandler<NewsContext> {
    public NewsHandler(final IexProxy iexProxy) {
        super(iexProxy, "news");
    }

    @Override
    protected NewsContext createContext(
        final IexProxy iexProxy,
        final ProxySession session,
        final Map<?, ?> json)
        throws HttpException, JsonUnexpectedTokenException
    {
        return new NewsContext(iexProxy, session, json);
    }

    @Override
    protected void handle(final NewsContext context)
        throws JsonUnexpectedTokenException, BadRequestException
    {
        context.response();
    }
}
