package ru.yandex.iex.proxy.paymenthandler;

import java.util.HashMap;
import java.util.List;
import java.util.Map;

import org.apache.http.HttpException;
import org.apache.http.HttpStatus;

import ru.yandex.http.proxy.ProxySession;
import ru.yandex.iex.proxy.AbstractEntityContext;
import ru.yandex.iex.proxy.IexProxy;
import ru.yandex.iex.proxy.XJsonUtils;
import ru.yandex.json.writer.JsonType;
import ru.yandex.json.xpath.JsonUnexpectedTokenException;

public class PaymentContext extends AbstractEntityContext {
    private Map<Object, Object> response = new HashMap<>();

    public PaymentContext(
        final IexProxy iexProxy,
        final ProxySession session,
        final Map<?, ?> json)
        throws HttpException, JsonUnexpectedTokenException
    {
        super(iexProxy, session, json);
        Object s = XJsonUtils.getNodeByPathOrNullEless(json, "payment");
        if (s instanceof List && !((List) s).isEmpty()) {
            Object n = ((List) s).get(0);
            if (n instanceof Map) {
                response.putAll((Map<?, ?>) n);
            }
        }
    }

    @Override
    public void response() {
        session.response(
            HttpStatus.SC_OK,
            JsonType.NORMAL.toString(response));
    }
}
