package ru.yandex.iex.proxy.paymenthandler;

import java.util.Map;

import org.apache.http.HttpException;

import ru.yandex.http.proxy.ProxySession;
import ru.yandex.http.util.BadRequestException;
import ru.yandex.iex.proxy.AbstractEntityHandler;
import ru.yandex.iex.proxy.IexProxy;
import ru.yandex.json.xpath.JsonUnexpectedTokenException;

public class PaymentHandler extends AbstractEntityHandler<PaymentContext> {
    public PaymentHandler(final IexProxy iexProxy) {
        super(iexProxy, "payment");
    }

    @Override
    protected PaymentContext createContext(
        final IexProxy iexProxy,
        final ProxySession session,
        final Map<?, ?> json)
        throws HttpException, JsonUnexpectedTokenException
    {
        return new PaymentContext(iexProxy, session, json);
    }

    @Override
    protected void handle(final PaymentContext context)
        throws JsonUnexpectedTokenException, BadRequestException
    {
        context.response();
    }
}
