package ru.yandex.iex.proxy.refundhandler;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Map.Entry;
import java.util.Set;
import java.util.TimeZone;

import org.apache.http.HttpException;

import ru.yandex.http.proxy.ProxySession;
import ru.yandex.iex.proxy.IexProxy;
import ru.yandex.json.xpath.JsonUnexpectedTokenException;
import ru.yandex.json.xpath.ValueUtils;

public class AlfaFraudProcessor extends RefundProcessor {
    public static final String DATE = "date";
    public static final String ECI = "ECI";
    public static final String IP_ADDRESS = "ip_address";
    public static final String REFUND_FBL = "refund_fbl";
    public static final String FIELD_NAME_FOR_TRANS_COUNT = "amount";
    public static final String XPATH_LIST_DELIMITER = "\\|";
    public static final TimeZone TIMEZONE = TimeZone.getTimeZone("Europe/Moscow");
    public static final Map<String, String> fieldNamesAlfaFraudToDBNames = Map.of(
            "date", "dt",
            "auth_code", "approval_code",
            "merchant_name", "service_name",
            "order_number", "possible_trust_payment_id",
            "currency", "currency_code",
            "card_number", "user_account"
        );
    public static final Set<String> fieldNamesAlfaFraudToIgnore = Set.of(
            "status",
            "state",
            "func_code",
            "mcc",
            "chargeback_amount",
            "chargeback_curr",
            "chargeback_date",
            "time",
            "ECI",
            "three_ds",
            "ip_address",
            "order_description"
        );
    private String stid;
    private Long mid;
    private Long uid;
    private ArrayList<Map<Object,Object>> alfaFraudRefundResponse;
    private ArrayList<Map<Object,Object>> transactionsToTheNextHop;
    private ArrayList<Map<Object,Object>> transposedResponse;

    protected final IexProxy iexProxy;
    protected final Map<?, ?> json;
    protected final ProxySession session;

    public AlfaFraudProcessor(
        final IexProxy iexProxy,
        final ProxySession session,
        final RefundContext refundContext,
        final Map<?, ?> json)
        throws HttpException, JsonUnexpectedTokenException
    {
        super(iexProxy, session, refundContext, json);
        this.iexProxy = iexProxy;
        this.session = session;
        this.json = json;
        stid = session.params().getString("stid", "");
        transposedResponse = new ArrayList<>();
        alfaFraudRefundResponse = new ArrayList<>();
        Map<?, ?> alfaFraudCokeResponse = null;

        if (json != null && json.get(REFUND_FBL) != null) {
            List<?> listResponses = ValueUtils.asList(json.get(REFUND_FBL));
            int maxResponseSize = 0;
            for (Object response : listResponses) {
                int responseSize = ((Map<?, ?>) response).size();
                if (responseSize > maxResponseSize) {
                    alfaFraudCokeResponse = ValueUtils.asMap(response);
                    maxResponseSize = responseSize;
                }
            }
        }
        if (alfaFraudCokeResponse != null) {
            int transactionsCount = 0;
            if(alfaFraudCokeResponse.containsKey(FIELD_NAME_FOR_TRANS_COUNT)) {
                transactionsCount = alfaFraudCokeResponse.get(FIELD_NAME_FOR_TRANS_COUNT).
                    toString().split(XPATH_LIST_DELIMITER).length;
            }
            for (Map.Entry<?,?> entry : alfaFraudCokeResponse.entrySet())  {
                String initialValue = entry.getValue().toString();
                if (initialValue.length() == 0) {
                    continue;
                }
                String[] values = initialValue.split(XPATH_LIST_DELIMITER);
                int i = 0;
                for (int valueNum = 0;
                         valueNum < Math.min(transactionsCount, values.length);
                         ++valueNum)
                {
                    int placeToPut = i;
                    Object key = entry.getKey();
                    String trimmedValue = values[valueNum].replaceAll("\u00a0","").trim();
                    int len = trimmedValue.length();
                    if (trimmedValue.contains(ECI) && len > 3) {
                        placeToPut--;
                        key = ECI;
                        trimmedValue = trimmedValue.substring(4);
                    }
                    if (key.equals(DATE) && len == 8) {
                        trimmedValue = new StringBuilder(trimmedValue).insert(6, '.').insert(4, '.').toString();
                    }
                    if (key.equals("time") && (len == 5 || len == 6)) {
                        trimmedValue = new StringBuilder(trimmedValue).insert(len - 2, ':').insert(len - 4, ':').toString();
                    }
                    if (key.equals("time") && (len == 4)) {
                        trimmedValue = new StringBuilder(trimmedValue).insert(len - 2, ':').insert(len - 4, "00:").toString();
                    }
                    if (transposedResponse.size() <= i) {
                        Map<Object, Object> map = new HashMap<>();
                        map.put(key, trimmedValue);
                        transposedResponse.add(map);
                    } else {
                        transposedResponse.get(placeToPut).put(key, trimmedValue);
                    }
                    ++i;
                }
            }
            for (Map<Object,Object> map : transposedResponse) {
                if (map.containsKey(DATE)
                        && (map.get(DATE).toString().length() == 0 || map.get(DATE).toString().contains("UDATE")) &&
                    map.containsKey(IP_ADDRESS)
                        && (map.get(IP_ADDRESS).toString().length() == 0 || map.get(IP_ADDRESS).toString().contains("IP"))) {
                        continue;
                }
                alfaFraudRefundResponse.add(map);
            }
        }

        transactionsToTheNextHop = new ArrayList<>();

        outer:
        for (Map<Object, Object> map: alfaFraudRefundResponse) {
            Map<Object, Object> transactionInfo = new HashMap<>();
            for (Map.Entry<Object, Object> entry : map.entrySet()) {
                if (fieldNamesAlfaFraudToIgnore.contains(entry.getKey())) {
                    continue;
                }
                Object key;
                Object value;
                if (fieldNamesAlfaFraudToDBNames.containsKey(entry.getKey())) {
                    key = fieldNamesAlfaFraudToDBNames.get(entry.getKey());
                } else {
                    key = entry.getKey();
                }
                if (entry.getKey().equals("amount")) {
                    try {
                        value = Double.parseDouble(entry.getValue().toString().replace(',', '.'));
                    } catch (NumberFormatException e) {
                        parsedAsHtmlStatus = "fail";
                        transactionsToTheNextHop.clear();
                        transposedResponse.clear();
                        break outer;
                    }
                } else if (entry.getKey().equals("date")) {
                    String time = "";
                    if (map.containsKey("time")) {
                        time = " " + map.get("time");
                    }
                    value = entry.getValue() + time;
                } else {
                    value = entry.getValue().toString();
                }
                transactionInfo.put(key, value);
            }
            transactionsToTheNextHop.add(transactionInfo);
        }
    }

    @Override
    public ArrayList<Map<Object,Object>> getAxisResult() {
        return alfaFraudRefundResponse;
    }

    @Override
    public ArrayList<Map<Object,Object>> getTransactions() {
        return transactionsToTheNextHop;
    }
}
