package ru.yandex.iex.proxy.refundhandler;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Map.Entry;

import org.apache.http.HttpException;

import ru.yandex.http.proxy.ProxySession;
import ru.yandex.iex.proxy.IexProxy;
import ru.yandex.json.xpath.JsonUnexpectedTokenException;
import ru.yandex.json.xpath.ValueUtils;

public class CardpayProcessor extends RefundProcessor {
    public static final String DATE = "date";
    public static final String ECI = "ECI";
    public static final String IP_ADDRESS = "ip_address";
    public static final String REFUND_FBL = "refund_fbl";
    public static final String FIELD_NAME_FOR_TRANS_COUNT = "amount";
    public static final String XPATH_LIST_DELIMITER = "\\|";
    public static final Map<String, String> fieldNamesCardpayToDBNames = Map.of(
            "date", "dt",
            "amount", "amount",
            "reason_code", "reason_code",
            "currency", "currency_code",
            "merchant_name", "service_name",
            "merchant_id", "possible_trust_payment_id",
            "order_id", "order_number",
            "card_number", "user_account",
            "arn", "arn"
        );
    private String stid;
    private Long mid;
    private Long uid;
    private ArrayList<Map<Object,Object>> alfaFraudRefundResponse;
    private ArrayList<Map<Object,Object>> transactionsToTheNextHop;
    private ArrayList<Map<Object,Object>> transposedResponse;

    protected final IexProxy iexProxy;
    protected final Map<?, ?> json;
    protected final ProxySession session;

    public CardpayProcessor(
        final IexProxy iexProxy,
        final ProxySession session,
        final RefundContext refundContext,
        final Map<?, ?> json)
        throws HttpException, JsonUnexpectedTokenException
    {
        super(iexProxy, session, refundContext, json);
        this.iexProxy = iexProxy;
        this.session = session;
        this.json = json;
        stid = session.params().getString("stid", "");
        transposedResponse = new ArrayList<>();

        Map<?, ?> cardpayCokeResponse = null;
        if (json != null && json.get(RefundConstants.REFUND_FBL) != null) {
            List<?> listResponses = ValueUtils.asList(json.get(RefundConstants.REFUND_FBL));
            int maxResponseSize = 0;
            for (Object response : listResponses) {
                int responseSize = ((Map<?, ?>) response).size();
                if (responseSize > maxResponseSize) {
                    cardpayCokeResponse = ValueUtils.asMap(response);
                    maxResponseSize = responseSize;
                }
            }
        }
        if (cardpayCokeResponse != null) {
            int transactionsCount = 0;
            if(cardpayCokeResponse.containsKey(FIELD_NAME_FOR_TRANS_COUNT)) {
                transactionsCount = cardpayCokeResponse.get(FIELD_NAME_FOR_TRANS_COUNT).
                    toString().split(XPATH_LIST_DELIMITER).length;
            }
            for (Map.Entry<?,?> entry : cardpayCokeResponse.entrySet())  {
                String initialValue = entry.getValue().toString().
                    replaceAll("\\|\\|", "");
                if (initialValue.length() == 0) {
                    continue;
                }
                String[] values = initialValue.split(XPATH_LIST_DELIMITER);
                int i = 0;
                for (int valueNum = 0;
                         valueNum < Math.min(transactionsCount, values.length);
                         ++valueNum)
                {
                    String trimmedValue = values[valueNum].replaceAll("\u00a0","").trim();
                    if (entry.getKey().equals("amount")) {
                        trimmedValue = trimmedValue.substring(0, trimmedValue.indexOf(' '));
                    }
                    if (entry.getKey().equals("currency")) {
                        trimmedValue = trimmedValue.substring(trimmedValue.indexOf(' ')).trim();
                    }

                    if (transposedResponse.size() <= i) {
                        Map<Object, Object> map = new HashMap<>();
                        map.put(entry.getKey(), trimmedValue);
                        transposedResponse.add(map);
                    } else {
                        transposedResponse.get(i).put(entry.getKey(), trimmedValue);
                    }
                    ++i;
                }
            }
        }

        transactionsToTheNextHop = new ArrayList<>();

        outer:
        for (Map<Object, Object> map: transposedResponse) {
            Map<Object, Object> transactionInfo = new HashMap<>();
            for (Map.Entry<Object, Object> entry : map.entrySet()) {
                Object key;
                Object value;
                key = fieldNamesCardpayToDBNames.get(entry.getKey());
                if (entry.getKey().equals("amount")) {
                    try {
                        value = Double.parseDouble(entry.getValue().toString());
                    } catch (NumberFormatException e) {
                        parsedAsHtmlStatus = "fail";
                        transactionsToTheNextHop.clear();
                        transposedResponse.clear();
                        break outer;
                    }
                } else {
                    value = entry.getValue().toString();
                }
                transactionInfo.put(key, value);
            }
            transactionsToTheNextHop.add(transactionInfo);
        }
    }

    @Override
    public ArrayList<Map<Object,Object>> getAxisResult() {
        return transposedResponse;
    }

    @Override
    public ArrayList<Map<Object,Object>> getTransactions() {
        return transactionsToTheNextHop;
    }
}
