package ru.yandex.iex.proxy.refundhandler;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.StringWriter;

import org.apache.http.HttpEntityEnclosingRequest;
import org.apache.http.HttpException;
import org.apache.http.HttpHeaders;
import org.apache.http.HttpRequest;
import org.apache.http.HttpStatus;
import org.apache.http.concurrent.FutureCallback;
import org.apache.http.entity.ContentType;
import org.apache.http.nio.protocol.HttpAsyncExchange;
import org.apache.http.nio.protocol.HttpAsyncRequestConsumer;
import org.apache.http.nio.protocol.HttpAsyncRequestHandler;
import org.apache.http.protocol.HttpContext;

import ru.yandex.base64.Base64Encoder;
import ru.yandex.function.ByteArrayProcessable;
import ru.yandex.http.proxy.AbstractProxySessionCallback;
import ru.yandex.http.proxy.BasicProxySession;
import ru.yandex.http.proxy.ProxySession;
import ru.yandex.http.util.BadRequestException;
import ru.yandex.http.util.ServerException;
import ru.yandex.http.util.YandexHttpStatus;
import ru.yandex.http.util.nio.AsyncStringConsumerFactory;
import ru.yandex.http.util.nio.BasicAsyncRequestProducerGenerator;
import ru.yandex.http.util.nio.client.AsyncClient;
import ru.yandex.iex.proxy.IexProxy;
import ru.yandex.iex.proxy.xutils.spamreport.SpamReportSender;
import ru.yandex.io.StringBuilderWriter;
import ru.yandex.json.async.consumer.JsonAsyncTypesafeDomConsumer;
import ru.yandex.json.dom.BasicContainerFactory;
import ru.yandex.json.dom.JsonObject;
import ru.yandex.json.dom.JsonString;
import ru.yandex.json.parser.StringCollectorsFactory;
import ru.yandex.json.writer.JsonType;
import ru.yandex.json.writer.JsonWriter;
import ru.yandex.mail.search.MailSearchParams;

public class CbkRegisterHandler implements HttpAsyncRequestHandler<JsonObject> {

    private final IexProxy iexProxy;
    private ProxySession session;

    public CbkRegisterHandler(final IexProxy proxy) {
        this.iexProxy = proxy;
    }

    public void response() {
        session.response(
            HttpStatus.SC_OK,
            JsonType.NORMAL.toString(""));
    }

    public void response(int status, String desc) {
        session.response(
            status,
            JsonType.NORMAL.toString(desc));
    }

    @Override
    public HttpAsyncRequestConsumer<JsonObject> processRequest(
        final HttpRequest request,
        final HttpContext context)
        throws HttpException
    {
        if (!(request instanceof HttpEntityEnclosingRequest)) {
            throw new BadRequestException("Payload expected");
        }
        return new JsonAsyncTypesafeDomConsumer(
            ((HttpEntityEnclosingRequest) request).getEntity(),
            StringCollectorsFactory.INSTANCE,
            BasicContainerFactory.INSTANCE);
    }

    @Override
    public void handle(
        final JsonObject payload,
        final HttpAsyncExchange exchange,
        final HttpContext context)
        throws HttpException
    {
        session = new BasicProxySession(iexProxy, exchange, context);
        String stid = session.params().getString(MailSearchParams.STID);

        session.logger().info("CbkRegisterHandler: sending request to get eml");
            SpamReportSender.sendGetEmlRequest(
                iexProxy,
                session,
                stid,
                new EmlCbkCallback(session));
    }

    private class EmlCbkCallback
        extends AbstractProxySessionCallback<ByteArrayProcessable>
    {
        EmlCbkCallback(final ProxySession session) {
            super(session);
        }

        @Override
        @SuppressWarnings("FutureReturnValueIgnored")
        public void completed(final ByteArrayProcessable result) {
            StringBuilderWriter sbw = new StringBuilderWriter(new StringBuilder(""));
            try (JsonWriter writer = new JsonWriter(sbw)) {
                writer.startObject();
                writer.key("mid");
                writer.value("" + session.params().getString(MailSearchParams.MID));
                writer.key("mds_link");
                writer.value("" + session.params().getString(MailSearchParams.STID));
                ByteArrayOutputStream baos = new ByteArrayOutputStream();
                result.processWith(SpamReportSender.ByteArrayBodyFactory.INSTANCE).writeTo(baos);
                Base64Encoder encoder = new Base64Encoder();
                encoder.process(baos.toByteArray());
                writer.key("eml");
                writer.value(new JsonString(encoder.toString()));
                writer.endObject();

                BasicAsyncRequestProducerGenerator generator =
                    new BasicAsyncRequestProducerGenerator("/request-register", sbw.toString());
                generator.addHeader(
                    HttpHeaders.CONTENT_TYPE,
                    ContentType.APPLICATION_JSON.toString());
                generator.addHeader(
                    HttpHeaders.ACCEPT,
                    ContentType.APPLICATION_JSON.toString());

                session.logger().info("EmlCbkCallback: sending data: "
                        + JsonType.NORMAL.toString(sbw.toString()));
                AsyncClient refundClient =
                    iexProxy.refundClient().adjust(
                    session.context());
                refundClient.execute(
                    iexProxy.config().refundConfig().host(),
                    generator,
                    AsyncStringConsumerFactory.OK,
                    session.listener().
                        createContextGeneratorFor(refundClient),
                    new CbkCallback());
            } catch (IOException | HttpException e) {
                session.logger().info("CbkRegisterHandler: exception while constructing eml data");
                response();
            }
        }
    }

    private class CbkCallback implements FutureCallback<String> {
        @Override
        public void cancelled() {
            session.logger().info("CbkCallback: cancelled");
            response();
        }

        @Override
        public void failed(final Exception e) {
            StringWriter sw = new StringWriter();
            e.printStackTrace(new PrintWriter(sw));
            session.logger().info("CbkCallback: failed with " + sw.toString());
            if (e instanceof ServerException) {
                ServerException se = (ServerException) e;
                try {
                    session.logger().info("RefundCallback:"
                        + " uid = " + RefundConstants.CBK_REGISTER_UID
                        + " mid = " + session.params().getString(MailSearchParams.MID)
                        + " ServerException " + se.statusCode());
                    if (se.statusCode() == YandexHttpStatus.SC_ACCEPTED) {
                        session.logger().info("RefundCallback: mid is procesing in another req, skipping");
                        response(se.statusCode(), "OK, is processing");
                    } else if (se.statusCode() == 208) {
                        session.logger().info("RefundCallback: mid was processed in another req, skipping");
                        response(se.statusCode(), "OK, already processed");
                    } else {
                        session.logger().info("RefundCallback: mid failed with " + se.getMessage());
                        response(se.statusCode(), se.getMessage());
                    }
                } catch (BadRequestException be) {
                    session.logger().info("CbkRegisterHandler: HttpException");
                    response(se.statusCode(), se.getMessage());
                }
            } else {
                try {
                    session.logger().info("RefundCallback:"
                        + " uid = " + RefundConstants.CBK_REGISTER_UID
                        + " mid = " + session.params().getString(MailSearchParams.MID)
                        + " failed with " + sw.toString());
                } catch (BadRequestException be) {
                    session.logger().info("CbkRegisterHandler: HttpException");
                }
                response(YandexHttpStatus.SC_GATEWAY_TIMEOUT, "default, gateway timeout");
            }
            response();
        }

        @Override
        public void completed(final String result) {
            session.logger().info("CbkCallback: completed with: <" + result + '>');
            response();
        }
    }
}

