package ru.yandex.iex.proxy.refundhandler;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;

import org.apache.http.HttpException;
import org.apache.http.HttpStatus;

import ru.yandex.http.proxy.ProxySession;
import ru.yandex.iex.proxy.AbstractEntityContext;
import ru.yandex.iex.proxy.IexProxy;
import ru.yandex.iex.proxy.xutils.spamreport.SpamReportSender;
import ru.yandex.json.writer.JsonType;
import ru.yandex.json.xpath.JsonUnexpectedTokenException;

public class RefundContext extends AbstractEntityContext {
    public static final String REFUND_FBL = "refund_fbl";
    public static final String XPATH_LIST_DELIMITER = "\\|";
    private String stid;
    private List<Map<Object,Object>> refundResponse;
    private ArrayList<Map<Object,Object>> transactionsToTheNextHop;
    private boolean known = false;
    private boolean isFraud = false;
    private String parseAsHtml = "not_supported";
    private String bank = "unknown";
    private String handlerName = "unknown_handler";

    public RefundContext(
        final IexProxy iexProxy,
        final ProxySession session,
        final Map<?, ?> json)
        throws HttpException, JsonUnexpectedTokenException
    {
        super(iexProxy, session, json);
        stid = session.params().getString("stid", "");
        transactionsToTheNextHop = new ArrayList<>();
        if (iexProxy.getRefundRulesEmail().containsKey(getFrom())) {
            known = true;
            handleEmail(true, iexProxy.getRefundRulesEmail().get(getFrom()));
        } else if (iexProxy.getRefundRulesDomain().containsKey(getDomain())) {
            known = true;
            handleEmail(true, iexProxy.getRefundRulesDomain().get(getDomain()));
        } else {
            known = false;
            parseAsHtml = "not_supported";
            handleEmail(false, null);
        }
    }

    private void handleEmail(boolean known, RefundSettings settings)
        throws HttpException, JsonUnexpectedTokenException
    {
        RefundProcessor processor = null;
        boolean ignoreStats = false;
        if (settings == null) {
            session.logger().info("RefundContext: unknown sender");
        } else {
            handlerName = settings.getHandlerName();
            isFraud = settings.isFraud();
            if (handlerName.equals("ignore")) {
                ignoreStats = true;
                refundResponse = Collections.emptyList();
            } else if (handlerName.equals("alfa_emc")) {
                bank = "ALFA";
                session.logger().info("RefundContext: alfa_emc");
                processor = new AlfaEmcProcessor(
                    iexProxy,
                    session,
                    this,
                    json);
            } else if (handlerName.equals("alfa_fraud")) {
                bank = "ALFA";
                session.logger().info("RefundContext: alfa_fraud");
                processor = new AlfaFraudProcessor(
                    iexProxy,
                    session,
                    this,
                    json);
            } else if (handlerName.equals("sber_debate")) {
                bank = "SBER";
                processor = new SberDebateProcessor(
                    iexProxy,
                    session,
                    this,
                    json);
            } else if (handlerName.equals("tinkoff")) {
                bank = "Tinkoff";
                processor = new TinkoffProcessor(
                    iexProxy,
                    session,
                    this,
                    json);
            } else if (handlerName.equals("yoomoney")) {
                bank = "YMoney";
                String subject = session.params().getOrNull("subject");
                if (subject.contains("Реестр")) {
                    isFraud = true;
                    ignoreStats = true;
                    refundResponse = Collections.emptyList();
                } else {
                    processor = new YooMoneyProcessor(
                        iexProxy,
                        session,
                        this,
                        json);
                }
            } else if (handlerName.equals("cardpay")) {
                String subject = session.params().getOrNull("subject");
                if (subject.contains("Fraud")) {
                    isFraud = true;
                }
                bank = "Cardpay";
                processor = new CardpayProcessor(
                    iexProxy,
                    session,
                    this,
                    json);
            } else if (handlerName.equals("only_attach")) {
                if (getFrom().contains("ecommpay.com")) {
                    String subject = session.params().getOrNull("subject");
                    if (subject.contains("Fraud")) {
                        isFraud = true;
                    }
                }
                session.logger().info("RefundContext: only attach");
            } else {
                session.logger().info("RefundContext: unknown handler");
            }
        }
        if (processor != null) {
            transactionsToTheNextHop = processor.getTransactions();
            refundResponse = processor.getAxisResult();
            parseAsHtml = processor.parsedAsHtmlStatus();
        } else {
            parseAsHtml = "not_supported";
        }

        if (uid == RefundConstants.FRAUD_UID || uid == RefundConstants.DISPUTE_UID) {
            if (ignoreStats) {
                session.logger().info(handlerName + ": ignoring, do not send to stats");
                response();
            } else {
                EmlTransactionsCallback emlTransCallback =
                    new EmlTransactionsCallback(
                        session,
                        transactionsToTheNextHop,
                        this,
                        known,
                        parseAsHtml,
                        isFraud,
                        bank,
                        iexProxy);
                session.logger().info(handlerName + ": sending request to get eml");
                SpamReportSender.sendGetEmlRequest(
                    iexProxy,
                    session,
                    stid,
                    emlTransCallback);
            }
        } else {
            session.logger().info(handlerName + ": returning OK without eml");
            response();
        }
    }

    @Override
    public void response() {
        session.response(
            HttpStatus.SC_OK,
            JsonType.NORMAL.toString(refundResponse));
    }

    public void response(int status, String desc) {
        session.response(
            status,
            JsonType.NORMAL.toString(desc));
    }

    public String getStid() {
        return stid;
    }

}
