package ru.yandex.iex.proxy.refundhandler;

import java.util.Map;

import org.apache.http.HttpException;

import ru.yandex.http.proxy.ProxySession;
import ru.yandex.http.util.BadRequestException;
import ru.yandex.iex.proxy.AbstractEntityHandler;
import ru.yandex.iex.proxy.IexProxy;
import ru.yandex.json.writer.JsonType;
import ru.yandex.json.xpath.JsonUnexpectedTokenException;

public class RefundHandler
    extends AbstractEntityHandler<RefundContext>
{
    public RefundHandler(final IexProxy iexProxy) {
        super(iexProxy);
    }

    @Override
    protected RefundContext createContext(
            final IexProxy iexProxy,
            final ProxySession session,
            final Map<?, ?> json)
        throws HttpException, JsonUnexpectedTokenException
    {
        session.logger().info("creating RefundContext "
                + "with " + JsonType.NORMAL.toString(json));
        return new RefundContext(iexProxy, session, json);
    }

    @Override
    protected void handle(final RefundContext context)
        throws JsonUnexpectedTokenException, BadRequestException
    {
    }
}
