package ru.yandex.iex.proxy.refundhandler;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

import org.apache.http.HttpHost;
import org.apache.http.HttpRequest;
import org.apache.http.HttpStatus;
import org.apache.http.concurrent.FutureCallback;
import org.apache.http.nio.protocol.HttpAsyncExchange;
import org.apache.http.nio.protocol.HttpAsyncRequestHandler;
import org.apache.http.protocol.HttpContext;

import ru.yandex.http.proxy.AbstractProxySessionCallback;
import ru.yandex.http.proxy.BasicProxySession;
import ru.yandex.http.proxy.ProxySession;
import ru.yandex.http.util.MultiFutureCallback;
import ru.yandex.http.util.YandexHeaders;
import ru.yandex.http.util.nio.BasicAsyncRequestProducerGenerator;
import ru.yandex.http.util.nio.FakeAsyncConsumer;
import ru.yandex.http.util.nio.client.AsyncClient;
import ru.yandex.iex.proxy.IexProxy;
import ru.yandex.json.async.consumer.JsonAsyncTypesafeDomConsumerFactory;
import ru.yandex.json.dom.JsonList;
import ru.yandex.json.dom.JsonObject;
import ru.yandex.json.parser.JsonException;
import ru.yandex.json.writer.JsonType;

public class RefundMailInfoHandler implements HttpAsyncRequestHandler<HttpRequest> {
    protected final IexProxy iexProxy;

    public RefundMailInfoHandler(final IexProxy iexProxy) {
        this.iexProxy = iexProxy;
    }

    @Override
    public FakeAsyncConsumer<HttpRequest> processRequest(
        final HttpRequest request,
        final HttpContext context)
    {
        return new FakeAsyncConsumer<>(request);
    }

    @Override
    public void handle(
        final HttpRequest request,
        final HttpAsyncExchange exchange,
        final HttpContext context)
    {
        List<Long> uids = new ArrayList<>();
        uids.add(RefundConstants.FRAUD_UID);
        uids.add(RefundConstants.DISPUTE_UID);
        uids.add(RefundConstants.CBK_REGISTER_UID);
        try {
            ProxySession session = new BasicProxySession(iexProxy, exchange, context);
            AsyncClient client = iexProxy.gettextClient().adjust(context);
            HttpHost host =
                iexProxy.config().gettextConfig().host();
            final MultiFutureCallback<List<RefundMailInfo>> multiCallback =
                new MultiFutureCallback<>(new GetRefundMailInfoCallback(session));
            session.logger().info("got /get_refund_mail_info request with " + session);
            String dtFrom = session.params().getString("dt_from");
            String dtTo = session.params().getString("dt_to");
            String mailFrom = session.params().getString("mail_from");

            List<UidWithCallback> uidsWithCallbacks = new ArrayList<>();
            for (long uid: uids) {
                uidsWithCallbacks.add(new UidWithCallback(uid, multiCallback.newCallback()));
            }

            multiCallback.done();

            for (UidWithCallback uidWithCallback: uidsWithCallbacks) {
                long uid = uidWithCallback.uid();
                String uri = "/sequential/search?service=iex&prefix=" + uid
                    + "&text=(folder_type:inbox+AND+hid:0+AND+hdr_from:" + mailFrom + "+AND+received_day_p:%5b"
                    + dtFrom + "+TO+" + dtTo + "%5d)"
                    + "&get=mid,uid,hdr_to,stid,hdr_subject,attachments,received_date,hdr_from";

                session.logger().info("uri for /get_refund_mail_info is " + uri);
                session.logger().info("host for /get_refund_mail_info is " + host);
                BasicAsyncRequestProducerGenerator producerGenerator =
                    new BasicAsyncRequestProducerGenerator(uri);
                producerGenerator.addHeader(
                    YandexHeaders.SERVICE,
                    "corp_change_log");
                producerGenerator.addHeader(
                    YandexHeaders.ZOO_SHARD_ID,
                    "" + uid % 65534);
                client.execute(
                    host,
                    producerGenerator,
                    JsonAsyncTypesafeDomConsumerFactory.OK,
                    session.listener().createContextGeneratorFor(client),
                    uidWithCallback);
            }
        } catch (Exception e) {
            exchange.getResponse().setStatusCode(
                HttpStatus.SC_SERVICE_UNAVAILABLE);
            exchange.submitResponse();
        }
    }

    @Override
    public String toString() {
        return "Handler for refund mails info rs for refund mails";
    }

    private static class UidWithCallback
        implements FutureCallback<JsonObject>
    {
        private final long uid;
        private final FutureCallback<List<RefundMailInfo>> callback;

        UidWithCallback(
            final long uid,
            final FutureCallback<List<RefundMailInfo>> callback)
        {
            this.uid = uid;
            this.callback = callback;
        }

        public long uid() {
            return uid;
        }

        public FutureCallback<List<RefundMailInfo>> callback() {
            return callback;
        }

        @Override
        public void cancelled() {
            callback.cancelled();
        }

        @Override
        public void failed(final Exception e) {
            callback.failed(e);
        }

        @Override
        public void completed(final JsonObject result) {
            try {
                List<RefundMailInfo> mailsInfo = new ArrayList<>();
                JsonList mailInfoJsonList = result.asMap().get("hitsArray").asList();
                for (JsonObject mailInfoRecord: mailInfoJsonList) {

                    String mid = mailInfoRecord.asMap().get("mid").asString();
                    String uid = mailInfoRecord.asMap().get("uid").asString();
                    String attachments = mailInfoRecord.asMap().getOrNull("attachments");
                    if (attachments == null) {
                        attachments = "";
                    }
                    String subject = mailInfoRecord.asMap().get("hdr_subject").asString();
                    String mailFrom = mailInfoRecord.asMap().get("hdr_from").asString();
                    String mailTo = mailInfoRecord.asMap().get("hdr_to").asString();
                    String receivedDate = mailInfoRecord.asMap().get("received_date").asString();
                    String stid = mailInfoRecord.asMap().get("stid").asString();
                    mailsInfo.add(new RefundMailInfo(
                                        mid,
                                        uid,
                                        attachments,
                                        subject,
                                        mailFrom,
                                        mailTo,
                                        receivedDate,
                                        stid));
                }
                callback.completed(mailsInfo);
            } catch (JsonException e) {
                callback.failed(e);
            }
        }
    }

    private static class RefundMailInfo {
        String mid;
        String uid;
        String attachments;
        String subject;
        String mailFrom;
        String mailTo;
        String receivedDate;
        String stid;

        public RefundMailInfo(
                final String mid,
                final String uid,
                final String attachments,
                final String subject,
                final String mailFrom,
                final String mailTo,
                final String receivedDate,
                final String stid) {
            this.mid = mid;
            this.uid = uid;
            this.attachments = attachments;
            this.subject = subject;
            this.mailFrom = mailFrom;
            this.mailTo = mailTo;
            this.receivedDate = receivedDate;
            this.stid = stid;
        }

        public String getMid() {
            return mid;
        }

        public String getUid() {
            return uid;
        }

        public String getAttachments() {
            return attachments;
        }

        public String getSubject() {
            return subject;
        }

        public String getMailFrom() {
            return mailFrom;
        }

        public String getMailTo() {
            return mailTo;
        }

        public String getReceivedDate() {
            return receivedDate;
        }

        public String getStid() {
            return stid;
        }
    }


    private static class GetRefundMailInfoCallback
        extends AbstractProxySessionCallback<List<List<RefundMailInfo>>>
    {
        GetRefundMailInfoCallback(final ProxySession session) {
            super(session);
        }

        @Override
        public void completed(final List<List<RefundMailInfo>> fewUidsResult) {
            Map<String, Object> resultRecords = new HashMap<>();
            List<Object> records = new ArrayList<>();

            for (List<RefundMailInfo> listResults: fewUidsResult) {
                for (RefundMailInfo result: listResults) {
                    Map<String, String> entry = new HashMap<>();
                    entry.put("mid", "" + result.getMid());
                    entry.put("uid", "" + result.getUid());
                    entry.put("attachments", "" + result.getAttachments());
                    entry.put("subject", "" + result.getSubject());
                    entry.put("mailFrom", "" + result.getMailFrom());
                    entry.put("mailTo", "" + result.getMailTo());
                    entry.put("receivedDate", "" + result.getReceivedDate());
                    entry.put("stid", result.getStid());
                    records.add(entry);
                }
            }
            resultRecords.put("hitsArray", records);
            resultRecords.put("hitsCount", records.size());

            session.logger().info("RefundMailInfoHandler: returning "
                    + JsonType.NORMAL.toString(resultRecords));
            session.response(HttpStatus.SC_OK, JsonType.NORMAL.toString(resultRecords));
        }
    }
}

