package ru.yandex.iex.proxy.refundhandler;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

import org.apache.http.HttpHost;
import org.apache.http.HttpRequest;
import org.apache.http.HttpStatus;
import org.apache.http.concurrent.FutureCallback;
import org.apache.http.nio.protocol.HttpAsyncExchange;
import org.apache.http.nio.protocol.HttpAsyncRequestHandler;
import org.apache.http.protocol.HttpContext;

import ru.yandex.http.proxy.AbstractProxySessionCallback;
import ru.yandex.http.proxy.BasicProxySession;
import ru.yandex.http.proxy.ProxySession;
import ru.yandex.http.util.MultiFutureCallback;
import ru.yandex.http.util.YandexHeaders;
import ru.yandex.http.util.nio.BasicAsyncRequestProducerGenerator;
import ru.yandex.http.util.nio.FakeAsyncConsumer;
import ru.yandex.http.util.nio.client.AsyncClient;
import ru.yandex.iex.proxy.IexProxy;
import ru.yandex.json.async.consumer.JsonAsyncTypesafeDomConsumerFactory;
import ru.yandex.json.dom.JsonList;
import ru.yandex.json.dom.JsonObject;
import ru.yandex.json.parser.JsonException;
import ru.yandex.json.writer.JsonType;

public class RefundMidUidPairsHandler implements HttpAsyncRequestHandler<HttpRequest> {
    protected final IexProxy iexProxy;

    public RefundMidUidPairsHandler(final IexProxy iexProxy) {
        this.iexProxy = iexProxy;
    }

    @Override
    public FakeAsyncConsumer<HttpRequest> processRequest(
        final HttpRequest request,
        final HttpContext context)
    {
        return new FakeAsyncConsumer<>(request);
    }

    @Override
    public void handle(
        final HttpRequest request,
        final HttpAsyncExchange exchange,
        final HttpContext context)
    {
        List<Long> uids = new ArrayList<>();
        uids.add(RefundConstants.FRAUD_UID);
        uids.add(RefundConstants.DISPUTE_UID);
        uids.add(RefundConstants.CBK_REGISTER_UID);
        try {
            ProxySession session = new BasicProxySession(iexProxy, exchange, context);
            AsyncClient client = iexProxy.gettextClient().adjust(context);
            HttpHost host =
                iexProxy.config().gettextConfig().host();
            final MultiFutureCallback<List<MidUidWithStid>> multiCallback =
                new MultiFutureCallback<>(new GetMidUidPairsCallback(session));
            session.logger().info("got /get_refund_mid_uid_pairs request with " + session);
            String dtFrom = session.params().getString("dt_from");
            String dtTo = session.params().getString("dt_to");

            List<UidWithCallback> uidsWithCallbacks = new ArrayList<>();
            for (long uid: uids) {
                uidsWithCallbacks.add(new UidWithCallback(uid, multiCallback.newCallback()));
            }

            multiCallback.done();

            for (UidWithCallback uidWithCallback: uidsWithCallbacks) {
                long uid = uidWithCallback.uid();
                String uri = "/sequential/search?service=iex&prefix=" + uid
                    + "&text=(folder_type:inbox+AND+hid:0+AND+received_day_p:%5b"
                    + dtFrom + "+TO+" + dtTo + "%5d)&get=mid,stid";

                session.logger().info("uri for /get_refund_mid_uid_pairs is " + uri);
                session.logger().info("host for /get_refund_mid_uid_pairs is " + host);
                BasicAsyncRequestProducerGenerator producerGenerator =
                    new BasicAsyncRequestProducerGenerator(uri);
                producerGenerator.addHeader(
                    YandexHeaders.SERVICE,
                    "corp_change_log");
                producerGenerator.addHeader(
                    YandexHeaders.ZOO_SHARD_ID,
                    "" + uid % 65534);
                client.execute(
                    host,
                    producerGenerator,
                    JsonAsyncTypesafeDomConsumerFactory.OK,
                    session.listener().createContextGeneratorFor(client),
                    uidWithCallback);
            }
        } catch (Exception e) {
            exchange.getResponse().setStatusCode(
                HttpStatus.SC_SERVICE_UNAVAILABLE);
            exchange.submitResponse();
        }
    }

    @Override
    public String toString() {
        return "Handler for mid-uid pairs for refund mails";
    }

    private static class UidWithCallback
        implements FutureCallback<JsonObject>
    {
        private final long uid;
        private final FutureCallback<List<MidUidWithStid>> callback;

        UidWithCallback(
            final long uid,
            final FutureCallback<List<MidUidWithStid>> callback)
        {
            this.uid = uid;
            this.callback = callback;
        }

        public long uid() {
            return uid;
        }

        public FutureCallback<List<MidUidWithStid>> callback() {
            return callback;
        }

        @Override
        public void cancelled() {
            callback.cancelled();
        }

        @Override
        public void failed(final Exception e) {
            callback.failed(e);
        }

        @Override
        public void completed(final JsonObject result) {
            try {
                List<MidUidWithStid> midUidWithStids = new ArrayList<>();
                JsonList midsStidJsonList = result.asMap().get("hitsArray").asList();
                for (JsonObject midStid: midsStidJsonList) {
                    String mid = midStid.asMap().get("mid").asString();
                    String stid = midStid.asMap().get("stid").asString();
                    midUidWithStids.add(new MidUidWithStid("mid=" + mid + "&uid=" + uid, stid));
                }
                callback.completed(midUidWithStids);
            } catch (JsonException e) {
                callback.failed(e);
            }
        }
    }

    private static class MidUidWithStid {
        String midUid;
        String stid;

        public MidUidWithStid(final String midUid, final String stid) {
            this.midUid = midUid;
            this.stid = stid;
        }

        public String getMidUid() {
            return midUid;
        }

        public String getStid() {
            return stid;
        }
    }


    private static class GetMidUidPairsCallback
        extends AbstractProxySessionCallback<List<List<MidUidWithStid>>>
    {
        GetMidUidPairsCallback(final ProxySession session) {
            super(session);
        }

        @Override
        public void completed(final List<List<MidUidWithStid>> fewUidsResult) {
            Map<String, Object> resultPairs = new HashMap<>();
            List<Object> pairs = new ArrayList<>();

            for (List<MidUidWithStid> listResults: fewUidsResult) {
                for (MidUidWithStid result: listResults) {
                    Map<String, String> entry = new HashMap<>();
                    entry.put("mid_uid", "" + result.getMidUid());
                    entry.put("stid", result.getStid());
                    pairs.add(entry);
                }
            }
            resultPairs.put("hitsArray", pairs);
            resultPairs.put("hitsCount", pairs.size());

            session.logger().info("RefundMidUidPairsHandler: returning "
                    + JsonType.NORMAL.toString(resultPairs));
            session.response(HttpStatus.SC_OK, JsonType.NORMAL.toString(resultPairs));
        }
    }
}

