package ru.yandex.iex.proxy.refundhandler;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Map.Entry;
import java.util.TimeZone;

import org.apache.http.HttpException;
import org.apache.http.HttpStatus;

import ru.yandex.dbfields.MailIndexFields;
import ru.yandex.http.proxy.ProxySession;
import ru.yandex.iex.proxy.IexProxy;
import ru.yandex.json.writer.JsonType;
import ru.yandex.json.xpath.JsonUnexpectedTokenException;
import ru.yandex.json.xpath.ValueUtils;

public abstract class RefundProcessor {
    public static final String XPATH_LIST_DELIMITER = "\\|";
    public static final TimeZone TIMEZONE = TimeZone.getTimeZone("Europe/Moscow");
    private RefundContext refundContext;
    private ArrayList<Map<Object,Object>> transactionsToTheNextHop;
    private String stid;
    private Long mid;
    private Long uid;
    private Long receivedDate;
    private ArrayList<Map<Object,Object>> transposedResponse;

    protected final IexProxy iexProxy;
    protected final Map<?, ?> json;
    protected final ProxySession session;
    protected String parsedAsHtmlStatus = "ok";

    public RefundProcessor(
        final IexProxy iexProxy,
        final ProxySession session,
        final RefundContext refundContext,
        final Map<?, ?> json)
        throws HttpException, JsonUnexpectedTokenException
    {
        this.refundContext = refundContext;
        receivedDate =
            ValueUtils.asLong(session.params().getString(MailIndexFields.RECEIVED_DATE));
        transactionsToTheNextHop = new ArrayList<>();
        this.iexProxy = iexProxy;
        this.session = session;
        this.json = json;
        mid = session.params().getLong("mid", 0L);
        uid = session.params().getLong("uid", 0L);
        stid = session.params().getString("stid", "");
        transposedResponse = new ArrayList<>();
        Map<?, ?> cokeResponse = null;
        if (json != null && json.get(RefundConstants.REFUND_FBL) != null) {
            List<?> listResponses = ValueUtils.asList(json.get(RefundConstants.REFUND_FBL));
            int maxResponseSize = 0;
            for (Object response : listResponses) {
                int responseSize = ((Map<?, ?>) response).size();
                if (responseSize > maxResponseSize) {
                    cokeResponse = ValueUtils.asMap(response);
                    maxResponseSize = responseSize;
                }
            }
        }
        if (cokeResponse != null) {
            for (Map.Entry<?,?> entry : cokeResponse.entrySet())  {
                String initialValue = entry.getValue().toString().
                    replaceAll("\\|\\|", "");
                if (initialValue.length() == 0) {
                    continue;
                }
                String[] values = initialValue.split(XPATH_LIST_DELIMITER);
                int i = 0;
                for (String v : values) {
                        String trimmedValue = v.replaceAll("\u00a0","").trim();
                    if (transposedResponse.size() <= i) {
                        Map<Object, Object> map = new HashMap<>();
                        map.put(entry.getKey(), trimmedValue);
                        transposedResponse.add(map);
                    } else {
                        transposedResponse.get(i).put(entry.getKey(), trimmedValue);
                    }
                    ++i;
                }
            }
        }
    }

    abstract public ArrayList<Map<Object,Object>> getAxisResult();

    abstract public ArrayList<Map<Object,Object>> getTransactions();

    protected String parsedAsHtmlStatus() {
        return parsedAsHtmlStatus;
    }

    public void response() {
        session.response(
            HttpStatus.SC_OK,
            JsonType.NORMAL.toString(transposedResponse));
    }

}
