package ru.yandex.iex.proxy.refundhandler;

public class RefundSettings {
    boolean parseAsHtml;
    String handlerName;
    boolean isFraud;

    public RefundSettings(final String[] settings) {
        if (settings.length == 1) {
            this.parseAsHtml = Boolean.parseBoolean(settings[0]);
        } else if (settings.length == 2) {
            this.parseAsHtml = Boolean.parseBoolean(settings[0]);
            this.handlerName = settings[1];
        } else {
            this.parseAsHtml = Boolean.parseBoolean(settings[0]);
            this.handlerName = settings[1];
            this.isFraud = Boolean.parseBoolean(settings[2]);
        }
    }

    @SuppressWarnings("unused")
    public boolean isParseAsHtml() {
        return parseAsHtml;
    }

    public String getHandlerName() {
        return handlerName;
    }

    public boolean isFraud() {
        return isFraud;
    }

    @Override
    public String toString() {
        return "" + parseAsHtml + ", " + handlerName + ", " + isFraud;
    }
}
