package ru.yandex.iex.proxy.refundhandler;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Map.Entry;
import java.util.Set;
import java.util.TimeZone;

import org.apache.http.HttpException;

import ru.yandex.http.proxy.ProxySession;
import ru.yandex.iex.proxy.IexProxy;
import ru.yandex.json.xpath.JsonUnexpectedTokenException;
import ru.yandex.json.xpath.ValueUtils;

public class TinkoffProcessor extends RefundProcessor {
    public static final String XPATH_LIST_DELIMITER = "\\|";
    public static final TimeZone TIMEZONE = TimeZone.getTimeZone("Europe/Moscow");
    public static final Map<String, String> fieldNamesTinkoffToDBNames = Map.of(
            "date", "dt",
            "order_id", "possible_trust_payment_id",
            "amount", "amount",
            "address", "address",
            "card_number", "user_account",
            "city", "city",
            "service_name", "service_name",
            "rrn", "rrn",
            "cbk_code", "reason_code",
            "auth_code", "approval_code"
        );
    public static final Set<String> fieldNamesTinkoffToIgnore = Set.of(
            "arn",
            "reason_code",
            "currency",
            "deadline",
            "ip_address",
            "mcc",
            "merchant_id",
            "merchant_name",
            "rc",
            "service_info",
            "three_ds"
        );
    private ArrayList<Map<Object,Object>> transactionsToTheNextHop;
    private String stid;
    private Long mid;
    private Long uid;
    private ArrayList<Map<Object,Object>> transposedResponse;

    protected final IexProxy iexProxy;
    protected final Map<?, ?> json;
    protected final ProxySession session;

    public TinkoffProcessor(
        final IexProxy iexProxy,
        final ProxySession session,
        final RefundContext refundContext,
        final Map<?, ?> json)
        throws HttpException, JsonUnexpectedTokenException
    {
        super(iexProxy, session, refundContext, json);
        this.iexProxy = iexProxy;
        this.session = session;
        this.json = json;
        mid = session.params().getLong("mid", 0L);
        uid = session.params().getLong("uid", 0L);
        stid = session.params().getString("stid", "");
        transposedResponse = new ArrayList<>();

        Map<?, ?> cokeResponse = null;
        if (json != null && json.get(RefundConstants.REFUND_FBL) != null) {
            List<?> listResponses = ValueUtils.asList(json.get(RefundConstants.REFUND_FBL));
            int maxResponseSize = 0;
            for (Object response : listResponses) {
                int responseSize = ((Map<?, ?>) response).size();
                if (responseSize > maxResponseSize) {
                    cokeResponse = ValueUtils.asMap(response);
                    maxResponseSize = responseSize;
                }
            }
        }
        if (cokeResponse != null) {
            for (Map.Entry<?,?> entry : cokeResponse.entrySet())  {
                String initialValue = entry.getValue().toString().
                    replaceAll("\\|\\|", "");
                if (initialValue.length() == 0) {
                    continue;
                }
                String[] values = initialValue.split(XPATH_LIST_DELIMITER);
                int i = 0;
                for (String v : values) {
                        String trimmedValue = v.replaceAll("\u00a0","").trim();
                    if (transposedResponse.size() <= i) {
                        Map<Object, Object> map = new HashMap<>();
                        map.put(entry.getKey(), trimmedValue);
                        transposedResponse.add(map);
                    } else {
                        transposedResponse.get(i).put(entry.getKey(), trimmedValue);
                    }
                    ++i;
                }
            }
        }

        transactionsToTheNextHop = new ArrayList<>();

        outer:
        for (Map<Object, Object> map: transposedResponse) {
            Map<Object, Object> transactionInfo = new HashMap<>();
            for (Map.Entry<Object, Object> entry : map.entrySet()) {
                Object key;
                Object value;
                if (fieldNamesTinkoffToIgnore.contains(entry.getKey())) {
                    continue;
                }
                key = fieldNamesTinkoffToDBNames.get(entry.getKey());
                if (entry.getKey().equals("amount")) {
                    try {
                        value = Double.parseDouble(entry.getValue().toString().
                                           replaceAll("\\s+","").replace(',', '.'));
                    } catch (NumberFormatException e) {
                        parsedAsHtmlStatus = "fail";
                        transactionsToTheNextHop.clear();
                        transposedResponse.clear();
                        break outer;
                    }
                } else {
                    value = entry.getValue().toString();
                }
                transactionInfo.put(key, value);
            }
            transactionsToTheNextHop.add(transactionInfo);
        }
    }

    @Override
    public ArrayList<Map<Object,Object>> getAxisResult() {
        return transposedResponse;
    }

    @Override
    public ArrayList<Map<Object,Object>> getTransactions() {
        return transactionsToTheNextHop;
    }
}
