package ru.yandex.iex.proxy.snippethandler;

import java.util.HashMap;
import java.util.Map;

import org.apache.http.HttpException;
import org.apache.http.HttpStatus;

import ru.yandex.http.proxy.ProxySession;
import ru.yandex.iex.proxy.AbstractEntityContext;
import ru.yandex.iex.proxy.IexProxy;
import ru.yandex.iex.proxy.XJsonUtils;
import ru.yandex.json.writer.JsonType;
import ru.yandex.json.xpath.JsonUnexpectedTokenException;

public class SnippetContext extends AbstractEntityContext {
    public static final String LENGTH = "length";
    private Map<Object, Object> response = new HashMap<>();

    public SnippetContext(
        final IexProxy iexProxy,
        final ProxySession session,
        final Map<?, ?> json)
        throws HttpException, JsonUnexpectedTokenException
    {
        super(iexProxy, session, json);
        Object s = XJsonUtils.getNodeByPathOrNullEless(json, "snippet", "text");

        if (s instanceof String) {
            response.put(LENGTH, ((String) s).length());
        } else {
            response.put(LENGTH, -1);
        }
    }

    @Override
    public void response() {
        session.response(
            HttpStatus.SC_OK,
            JsonType.NORMAL.toString(response));
    }
}
