package ru.yandex.iex.proxy.snippethandler;

import java.util.Map;

import org.apache.http.HttpException;

import ru.yandex.http.proxy.ProxySession;
import ru.yandex.http.util.BadRequestException;
import ru.yandex.iex.proxy.AbstractEntityHandler;
import ru.yandex.iex.proxy.IexProxy;
import ru.yandex.json.xpath.JsonUnexpectedTokenException;

public class SnippetHandler extends AbstractEntityHandler<SnippetContext> {
    public SnippetHandler(final IexProxy iexProxy) {
        super(iexProxy);
    }

    @Override
    protected SnippetContext createContext(
        final IexProxy iexProxy,
        final ProxySession session,
        final Map<?, ?> json)
        throws HttpException, JsonUnexpectedTokenException
    {
        return new SnippetContext(iexProxy, session, json);
    }

    @Override
    protected void handle(final SnippetContext context)
        throws JsonUnexpectedTokenException, BadRequestException
    {
        context.response();
    }
}
