package ru.yandex.iex.proxy.snippethandler;

import java.util.HashMap;
import java.util.Map;

import org.apache.http.HttpException;
import org.apache.http.HttpStatus;

import ru.yandex.http.proxy.ProxySession;
import ru.yandex.iex.proxy.AbstractEntityContext;
import ru.yandex.iex.proxy.IexProxy;
import ru.yandex.iex.proxy.XJsonUtils;
import ru.yandex.json.writer.JsonType;
import ru.yandex.json.xpath.JsonUnexpectedTokenException;

public class SnippetTextContext extends AbstractEntityContext {
    public static final String TEXT = "text";
    public static final String TEXT_HTML = "text_html";
    public static final String SNIPPET = "snippet";
    private Map<Object, Object> response = new HashMap<>();

    public SnippetTextContext(
        final IexProxy iexProxy,
        final ProxySession session,
        final Map<?, ?> json)
        throws HttpException, JsonUnexpectedTokenException
    {
        super(iexProxy, session, json);
        Object s = XJsonUtils.getNodeByPathOrNullEless(json, SNIPPET, TEXT);
        Object s1 =
            XJsonUtils.getNodeByPathOrNullEless(json, SNIPPET, TEXT_HTML);
        response.put(TEXT, s);
        response.put(TEXT_HTML, s1);
    }

    @Override
    public void response() {
        session.response(
            HttpStatus.SC_OK,
            JsonType.NORMAL.toString(response));
    }
}
