package ru.yandex.iex.proxy.snippethandler;

import java.util.Map;

import org.apache.http.HttpException;

import ru.yandex.http.proxy.ProxySession;
import ru.yandex.http.util.BadRequestException;
import ru.yandex.iex.proxy.AbstractEntityHandler;
import ru.yandex.iex.proxy.IexProxy;
import ru.yandex.json.xpath.JsonUnexpectedTokenException;

public class SnippetTextHandler
    extends AbstractEntityHandler<SnippetTextContext>
{
    public SnippetTextHandler(final IexProxy iexProxy) {
        super(iexProxy);
    }

    @Override
    protected SnippetTextContext createContext(
        final IexProxy iexProxy,
        final ProxySession session,
        final Map<?, ?> json)
        throws HttpException, JsonUnexpectedTokenException
    {
        return new SnippetTextContext(iexProxy, session, json);
    }

    @Override
    protected void handle(final SnippetTextContext context)
        throws JsonUnexpectedTokenException, BadRequestException
    {
        context.response();
    }
}
