package ru.yandex.iex.proxy.taxihandler;

import java.util.Map;
import java.util.logging.Level;

import org.apache.http.concurrent.FutureCallback;

import ru.yandex.geocoder.GeocoderResult;
import ru.yandex.http.util.HttpExceptionConverter;
import ru.yandex.http.util.ServerException;
import ru.yandex.http.util.YandexHttpStatus;
import ru.yandex.iex.proxy.XJsonUtils;
import ru.yandex.json.xpath.JsonUnexpectedTokenException;
import ru.yandex.stater.RequestInfo;
import ru.yandex.util.timesource.TimeSource;

public class TaxiCallback
    implements FutureCallback<GeocoderResult>
{
    private final long start = TimeSource.INSTANCE.currentTimeMillis();
    protected TaxiContext context;

    TaxiCallback(final TaxiContext context) {
        this.context = context;
    }

    @Override
    public void completed(final GeocoderResult result) {
        stat(YandexHttpStatus.SC_OK);
        if (result.getGeoid() != -1) {
            Map<?, ?> output = context.firstNodeOftaxiJson();
            if (output != null) {
                try {
                    XJsonUtils.pushToMap(
                        output,
                        "geocoder_geoid",
                        result.getGeoid());
                } catch (JsonUnexpectedTokenException e) {
                }
            }
        }
        context.response();
    }

    @Override
    public void cancelled() {
        stat(YandexHttpStatus.SC_CLIENT_CLOSED_REQUEST);
        this.context.session()
            .logger()
            .warning("Request cancelled: "
                + this.context.session().listener().details());
        context.session().response(YandexHttpStatus.SC_CLIENT_CLOSED_REQUEST);
    }

    @Override
    public void failed(final Exception e) {
        if (e instanceof ServerException) {
            stat(((ServerException) e).statusCode());
        } else {
            stat(YandexHttpStatus.SC_REMOTE_CLOSED_REQUEST);
        }
        this.context.session()
            .logger()
            .log(Level.WARNING, "Failed to process: "
                + context.humanReadableJson()
                + '\n' + context.session().listener().details()
                + " because of exception", e);
        context.session().handleException(
            HttpExceptionConverter.toHttpException(e));
    }

    private void stat(final int status) {
        context.iexProxy().geoRequestsStater().accept(
            new RequestInfo(
                TimeSource.INSTANCE.currentTimeMillis(),
                status,
                start,
                start,
                0L,
                0L));
    }
}
