package ru.yandex.iex.proxy.taxihandler;

import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;

import org.apache.http.HttpException;
import org.apache.http.HttpStatus;

import ru.yandex.http.proxy.ProxySession;
import ru.yandex.iex.proxy.AbstractEntityContext;
import ru.yandex.iex.proxy.IexProxy;
import ru.yandex.iex.proxy.XJsonUtils;
import ru.yandex.json.writer.JsonType;
import ru.yandex.json.xpath.JsonUnexpectedTokenException;
import ru.yandex.json.xpath.ValueUtils;

public class TaxiContext extends AbstractEntityContext {
    public static final String UNKNOWN = "unknown";
    public static final String MICRO = "micro";
    public static final String TAXI = "taxi";
    private Object taxiJson;
    private Map<?, ?> ptrToTaxiJsonFirstNode;

    public TaxiContext(
        final IexProxy iexProxy,
        final ProxySession session,
        final Map<?, ?> json)
        throws HttpException, JsonUnexpectedTokenException
    {
        super(iexProxy, session, json);
        taxiJson =
            XJsonUtils.getNodeByPathOrNull(json, MICRO, UNKNOWN, TAXI);
        if (taxiJson == null) {
            taxiJson =
                XJsonUtils.getNodeByPathOrNull(json, MICRO, TAXI);
        }
        if (taxiJson == null) {
            taxiJson =
                XJsonUtils.getNodeByPathOrNull(json, TAXI);
        }
        if (taxiJson != null
            && XJsonUtils.deleteKeyIfEqualTo(
            taxiJson,
            "comfortsale",
            new StringBuilder().append('\u0000').toString()))
        {
            int cntKeys = XJsonUtils.countOfKeys(taxiJson);
            if (cntKeys == 0) {
                taxiJson = null;
            }
        }
        if (taxiJson != null) {
            if (taxiJson instanceof List) {
                for (Object x : (List) taxiJson) {
                    Map<?, ?> subm = ValueUtils.asMap(x);
                    ptrToTaxiJsonFirstNode = subm;
                    //"city_arr": "Мансфилд",
                    //"city_dep": "Лондон",
                    changeMDCity(subm, "city_arr");
                    changeMDCity(subm, "city_dep");
                    break; // ignore rest of elements
                }
            }
        }
    }

    public Object taxiJson() {
        return taxiJson;
    }

    public Map<?, ?> firstNodeOftaxiJson() {
        return ptrToTaxiJsonFirstNode;
    }

    @Override
    public void response() {
        session.response(HttpStatus.SC_OK, JsonType.NORMAL.toString(taxiJson));
    }

    private void changeMDCity(final Map<?, ?> subm, final String city)
        throws JsonUnexpectedTokenException
    {
        if (subm.containsKey(city)) {
            String v = ValueUtils.asString(subm.get(city));
            if (MoscowDistrict.isMD(v)) {
                XJsonUtils.pushToMap(
                    subm,
                    city,
                    "Московская область");
            }
        }
    }

    //TODO: make config with cities
    private static class MoscowDistrict {
        private static HashSet<String> cities =
            new HashSet<String>(Arrays.asList(
                "москва",
                "апрелевка",
                "балашиха",
                "бронницы",
                "верея",
                "видное",
                "волоколамск",
                "воскресенск",
                "высоковск",
                "голицыно",
                "дедовск",
                "дзержинский",
                "дмитров",
                "долгопрудный",
                "домодедово",
                "дрезна",
                "дубна",
                "егорьевск",
                "жуковский",
                "зарайск",
                "звенигород",
                "ивантеевка",
                "истра",
                "кашира",
                "клин",
                "коломна",
                "королёв",
                "котельники",
                "красноармейск",
                "красногорск",
                "краснозаводск",
                "краснознаменск",
                "кубинка",
                "куровское",
                "ликино-дулёво",
                "лобня",
                "лосино-петровский",
                "луховицы",
                "лыткарино",
                "люберцы",
                "можайск",
                "мытищи",
                "наро-фоминск",
                "ногинск",
                "одинцово",
                "озёры",
                "орехово-зуево",
                "павловский",
                "пересвет",
                "подольск",
                "протвино",
                "пушкино",
                "пущино",
                "раменское",
                "реутов",
                "рошаль",
                "руза",
                "сергиев",
                "серпухов",
                "солнечногорск",
                "старая",
                "ступино",
                "талдом",
                "фрязино",
                "химки",
                "хотьково",
                "черноголовка",
                "чехов",
                "шатура",
                "щёлково",
                "электрогорск",
                "электросталь",
                "электроугли"
                ));

        public static boolean isMD(final String city) {
            return cities.contains(city.toLowerCase(Locale.getDefault()));
        }
    }
}
