package ru.yandex.iex.proxy.tickethandlerlegacy;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.nio.charset.StandardCharsets;
import java.util.HashMap;
import java.util.Map;

public final class TicketAirportParser {
    private static TicketAirportParser instance;

    private static final int IATA_LENGTH = 3;
    private Map<String, String> iata2cityTable = new HashMap<>();

    static {
        try {
            instance = new TicketAirportParser();
        } catch (IOException e) {
            throw new RuntimeException(
                "TicketAirportParser creation failed",
                e);
        }
    }

    private TicketAirportParser() throws IOException {
        try (BufferedReader br = new BufferedReader(
            new InputStreamReader(
                TicketAirportParser.class.getResourceAsStream("iata2city.txt"),
                StandardCharsets.UTF_8)))
        {
            String line;
            while ((line = br.readLine()) != null) {
                String iata = line.substring(0, IATA_LENGTH);
                String city = line.substring(IATA_LENGTH + 1);
                if (!iata.isEmpty() && !city.isEmpty()) {
                    iata2cityTable.put(iata, city);
                }
            }
        }
    }

    public static TicketAirportParser getInstance() {
        return instance;
    }

    public String iata2city(final String iata) {
        return iata2cityTable.get(iata);
    }
}
