package ru.yandex.iex.proxy.tickethandlerlegacy;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.nio.charset.StandardCharsets;
import java.util.HashMap;
import java.util.Map;

public final class TicketDomainParser {
    private static TicketDomainParser instance;

    private static final String EMPTY = "-";
    private static final int DOMAIN_INDEX = 0;
    private static final int EN_IATA_INDEX = 1;
    private static final int RU_IATA_INDEX = 2;
    private static final int URL_INDEX = 3;
    private static final int FIELDS_COUNT = 4;

    private Map<String, String> urlByDomain = new HashMap<>();
    private Map<String, String> urlByAirlineIata = new HashMap<>();

    static {
        try {
            instance = new TicketDomainParser();
        } catch (IOException e) {
            throw new RuntimeException("TicketDomainParser creation failed", e);
        }
    }

    private TicketDomainParser() throws IOException {
        try (BufferedReader br = new BufferedReader(
            new InputStreamReader(
                TicketDomainParser.class.getResourceAsStream(
                    "checkin_urls.txt"),
                StandardCharsets.UTF_8)))
        {
            String line;
            while ((line = br.readLine()) != null) {
                String[] res = line.split("\\s+");
                if (res.length == FIELDS_COUNT) {
                    String url = res[URL_INDEX];
                    urlByDomain.put(res[DOMAIN_INDEX], url);
                    if (!res[RU_IATA_INDEX].equals(EMPTY)) {
                        urlByAirlineIata.put(res[RU_IATA_INDEX], url);
                    }
                    if (!res[EN_IATA_INDEX].equals(EMPTY)) {
                        urlByAirlineIata.put(res[EN_IATA_INDEX], url);
                    }
                }
            }
        }
    }

    public static TicketDomainParser getInstance() {
        return instance;
    }

    public String getCheckinUrl(final String domain, final String iata) {
        String url = urlByAirlineIata.get(iata);
        if (url == null) {
            url = urlByDomain.get(domain);
        }
        return url;
    }
}
