package ru.yandex.iex.proxy.tickethandlerlegacy;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

import org.apache.http.concurrent.FutureCallback;

import ru.yandex.geocoder.GeocoderClient;
import ru.yandex.geocoder.GeocoderRequest;
import ru.yandex.geocoder.GeocoderResult;
import ru.yandex.http.util.BadRequestException;
import ru.yandex.http.util.MultiFutureCallback;
import ru.yandex.http.util.ServerException;
import ru.yandex.http.util.YandexHeaders;
import ru.yandex.http.util.YandexHttpStatus;
import ru.yandex.iex.proxy.XMessageToLog;
import ru.yandex.json.xpath.JsonUnexpectedTokenException;
import ru.yandex.json.xpath.ValueUtils;
import ru.yandex.stater.RequestInfo;
import ru.yandex.util.timesource.TimeSource;

public class TicketGeoid {
    TicketGeoid(final TicketContext context) {
        final MultiFutureCallback<Object> multiCallback =
            new MultiFutureCallback<>(
                new FinishGeoidMulticallback(context));

        final List<TicketGeoidResultCallback> subCallbacks =
            new ArrayList<>();
        if (context.getTicketJson() != null) {
            for (final Map<String, Object> x : context.getTicketJson()) {
                String[] cityTypes = {
                    TicketIEX.CITY_ARR,
                    TicketIEX.CITY_ARR_BACK,
                    TicketIEX.CITY_DEP,
                    TicketIEX.CITY_DEP_BACK
                };
                for (final String city : cityTypes) {
                    Object extractedCity = x.get(city);
                    if (extractedCity != null
                        && !extractedCity.equals("undefined")
                        && !extractedCity.equals("")
                        && !extractedCity.equals("Undefined"))
                    {
                        subCallbacks.add(
                            new TicketGeoidResultCallback(
                                context,
                                multiCallback.newCallback(),
                                x,
                                city
                            ));
                    }
                }
            }
        }
        XMessageToLog.info(context, "TicketGeoid: " + subCallbacks.size()
                + " subcallbacks added");
        multiCallback.done();
        GeocoderClient client =
            context.iexProxy().geoSearchClient().adjust(
                context.session().context());
        for (final TicketGeoidResultCallback subCallback : subCallbacks) {
            try {
                if (subCallback.getCity().isEmpty()) {
                    XMessageToLog.info(context, "TicketGeoid: empty city");
                    subCallback.completed(null);
                } else {
                    XMessageToLog.info(context, "TicketGeoid: sending request"
                        + " for city " + subCallback.getCity());
                    GeocoderRequest request = new GeocoderRequest(
                        context.iexProxy().config().geoSearchConfig());
                    request.addHeader(
                        YandexHeaders.X_YA_SERVICE_TICKET,
                        context.iexProxy().geoTvm2Ticket());
                    request.setText(subCallback.getCity());
                    XMessageToLog.info(
                        context,
                        "Send geocoder request city: " + request.getQuery());
                    client.execute(
                        request,
                        context.session().listener()
                            .createContextGeneratorFor(client),
                        subCallback);
                }
            } catch (BadRequestException e) {
                XMessageToLog.error(context, "Geocoder request city error", e);
                // continue
            }
        }
    }
}

class TicketGeoidResultCallback
    implements FutureCallback<GeocoderResult>
{
    private final long start = TimeSource.INSTANCE.currentTimeMillis();
    private final TicketContext context;
    private final String city;
    private final Map<String, Object> relatedMap;
    private final String flightType;
    private final FutureCallback<Object> callback;

    //CSOFF: ParameterNumber
    TicketGeoidResultCallback(
        final TicketContext context,
        final FutureCallback<Object> callback,
        final Map<String, Object> x,
        final String cityType)
    {
        this.context = context;
        this.callback = callback;
        relatedMap = x;
        String city = "";
        try {
            city = ValueUtils.asString(x.get(cityType));
        } catch (JsonUnexpectedTokenException e) {
        }
        this.city = city;
        this.flightType = cityType;
    }
    //CSON: ParameterNumber

    @Override
    public void cancelled() {
        stat(YandexHttpStatus.SC_CLIENT_CLOSED_REQUEST);
        XMessageToLog.warning(context, "Geocoder request cancelled (city)");
        callback.completed(null);
    }

    @Override
    public void failed(final Exception e) {
        if (e instanceof ServerException) {
            stat(((ServerException) e).statusCode());
        } else {
            stat(YandexHttpStatus.SC_REMOTE_CLOSED_REQUEST);
        }
        XMessageToLog.error(context, "Geocoder request failed (city)", e);
        // if we've failed then just continue
        callback.completed(null);
        //callback.failed(e);
    }

    @Override
    public void completed(final GeocoderResult result) {
        if (result == null) {
            callback.completed(null);
        } else {
            stat(YandexHttpStatus.SC_OK);
            callback.completed(
                new ResultSubCallback(
                    relatedMap,
                    result,
                    flightType));
        }
    }

    public String getCity() {
        return "город " + city;
    }

    private void stat(final int status) {
        context.iexProxy().geoRequestsStater().accept(
            new RequestInfo(
                TimeSource.INSTANCE.currentTimeMillis(),
                status,
                start,
                start,
                0L,
                0L));
    }
}

class ResultSubCallback {
    public static final String GEOID = "_geoid";
    //private int geoid;
    private String country;
    private int cityGeoid;
    private Map<String, Object> amp;
    private String flightType;

    ResultSubCallback(
        final Map<String, Object> mp,
        final GeocoderResult result,
        final String key)
    {
        cityGeoid = result.getGeoid();
        country = result.getCountryName();
        amp = mp;
        this.flightType = key;
    }

    public void makeSafeAdding() {
        //amp.put(flightType + GEOID, String.valueOf(geoid));
        amp.put(flightType + "_country", String.valueOf(country));
        amp.put(flightType + GEOID, cityGeoid);
    }

    public String getCountry() {
        return country;
    }

    public void setCountryGeoid(final int countryGeoid) {
        String dir = "from";
        if (flightType.contains("arr")) {
            dir = "to";
        }
        amp.put(dir + "_country_geoid", String.valueOf(countryGeoid));
    }
}

class FinishGeoidMulticallback
    implements FutureCallback<List<Object>>
{
    private static final String LOG_PREFIX_MULTI =
        "TicketGeoid.FinishGeoidMulticallback";
    private final TicketContext context;

    FinishGeoidMulticallback(final TicketContext context) {
        this.context = context;
    }

    @Override
    public void completed(final List<Object> results) {
        XMessageToLog.info(context, LOG_PREFIX_MULTI
               + " completed");
        Map<String, ArrayList<ResultSubCallback>> cityGeoidm = new HashMap<>();
        for (final Object x : results) {
            if (x instanceof ResultSubCallback) {
                ResultSubCallback tmpx = (ResultSubCallback) x;
                tmpx.makeSafeAdding();
                final String country = tmpx.getCountry();
                if (!country.isEmpty()) {
                    if (cityGeoidm.containsKey(country)) {
                        cityGeoidm.get(country).add(tmpx);
                    } else {
                        ArrayList<ResultSubCallback> tmpl = new ArrayList<>();
                        tmpl.add(tmpx);
                        cityGeoidm.put(country, tmpl);
                    }
                }
            }
        }
        if (cityGeoidm.isEmpty()) {
            XMessageToLog.info(context, LOG_PREFIX_MULTI
                + " completed, city geoid is empty");
            context.mergeAllUniqFlightsInOne();
            context.getTransferType();
            (new TicketReminder(context)).handle();
        } else {
            // Need to get a country's geoid
            final MultiFutureCallback<Object> multiCountryCallback =
                new MultiFutureCallback<>(
                    new FinishCountryGeoidMulticallback(context));
            final List<CountryGeoidCallback> subCountryCallbacks =
                new ArrayList<>();
            for (final Map.Entry<String, ArrayList<ResultSubCallback>> x
                : cityGeoidm.entrySet())
            {
                subCountryCallbacks.add(
                    new CountryGeoidCallback(
                        context,
                        multiCountryCallback.newCallback(),
                        x.getValue(),
                        x.getKey()
                    ));
            }
            XMessageToLog.info(context, LOG_PREFIX_MULTI
                + " completed, prepared " + subCountryCallbacks.size()
                + " requests");
            multiCountryCallback.done();
            GeocoderClient client =
                context.iexProxy().geoSearchClient().adjust(
                    context.session().context());
            for (final CountryGeoidCallback subCallback : subCountryCallbacks) {
                try {
                    XMessageToLog.info(context, LOG_PREFIX_MULTI
                        + " completed, sending " + subCallback.getCountry()
                        + " request");
                    GeocoderRequest request = new GeocoderRequest(
                        context.iexProxy().config().geoSearchConfig());
                    request.addHeader(
                        YandexHeaders.X_YA_SERVICE_TICKET,
                        context.iexProxy().geoTvm2Ticket());
                    request.setText(subCallback.getCountry());
                    XMessageToLog.info(
                        context,
                        "Send geocoder request country: " + request.getQuery());
                    client.execute(
                        request,
                        context.session().listener()
                            .createContextGeneratorFor(client),
                        subCallback);
                } catch (BadRequestException e) {
                    XMessageToLog.error(
                        context,
                        "Geocoder request country error",
                        e);
                    // continue
                }
            }
        }
    }

    @Override
    public void cancelled() {
        context.response();
    }

    @Override
    public void failed(final Exception e) {
        context.failed(e);
    }
}

class CountryGeoidCallback implements FutureCallback<GeocoderResult> {
    private final long start = TimeSource.INSTANCE.currentTimeMillis();
    private final TicketContext context;
    private final List<ResultSubCallback> preResultOfMulticallback;
    private final FutureCallback<Object> callback;
    private final String country;

    //CSOFF: ParameterNumber
    CountryGeoidCallback(
        final TicketContext context,
        final FutureCallback<Object> callback,
        final ArrayList<ResultSubCallback> x,
        final String country)
    {
        this.context = context;
        this.callback = callback;
        preResultOfMulticallback = x;
        this.country = country;
    }
    //CSON: ParameterNumber

    @Override
    public void cancelled() {
        stat(YandexHttpStatus.SC_CLIENT_CLOSED_REQUEST);
        XMessageToLog.warning(context, "Geocoder request cancelled (country)");
        callback.completed(null);
    }

    @Override
    public void failed(final Exception e) {
        if (e instanceof ServerException) {
            stat(((ServerException) e).statusCode());
        } else {
            stat(YandexHttpStatus.SC_REMOTE_CLOSED_REQUEST);
        }
        XMessageToLog.error(context, "Geocoder request failed (country)", e);
        callback.completed(null);
    }

    @Override
    public void completed(final GeocoderResult result) {
        if (result != null) {
            stat(YandexHttpStatus.SC_OK);
            int geoid = result.getGeoid();
            for (final ResultSubCallback x : preResultOfMulticallback) {
                x.setCountryGeoid(geoid);
            }
        }
        callback.completed(null);
    }

    public String getCountry() {
        return country;
    }

    private void stat(final int status) {
        context.iexProxy().geoRequestsStater().accept(
            new RequestInfo(
                TimeSource.INSTANCE.currentTimeMillis(),
                status,
                start,
                start,
                0L,
                0L));
    }
}

class FinishCountryGeoidMulticallback
    implements FutureCallback<List<Object>>
{
    private final TicketContext context;

    FinishCountryGeoidMulticallback(final TicketContext context) {
        this.context = context;
    }

    @Override
    public void completed(final List<Object> results) {
        context.mergeAllUniqFlightsInOne();
        context.getTransferType();
        (new TicketReminder(context)).handle();
    }

    @Override
    public void cancelled() {
        context.response();
    }

    @Override
    public void failed(final Exception e) {
        context.failed(e);
    }
}
