package ru.yandex.iex.proxy.tickethandlerlegacy;

import java.util.HashMap;
import java.util.Map;
import java.util.logging.Level;

import ru.yandex.http.util.nio.BasicAsyncRequestProducerGenerator;
import ru.yandex.http.util.nio.client.AsyncClient;
import ru.yandex.iex.proxy.XMessageToLog;
import ru.yandex.json.async.consumer.JsonAsyncDomConsumerFactory;
import ru.yandex.json.writer.JsonType;
import ru.yandex.json.xpath.JsonUnexpectedTokenException;
import ru.yandex.json.xpath.ValueUtils;

public class TicketReminder {
    public static final int OFFSET2 = -180; // email, sms reminder
    public static final int OFFSET1 = -180; //
    public static final String UID = "uid";
    public static final String MAIL_HANDLE = "/mail/";
    public static final String SCHEME_DELIMITER = "://";
    private TicketContext context;

    TicketReminder(final TicketContext context) {
        this.context = context;
    }

    public void handle() {
        try {
            if (context.getTicketJson() == null
                || context.getTicketJson().size() == 0)
            {
                context.session().logger()
                    .warning("No flights found in TicketReminder");
                context.response();
                return;
            }
            context.session().logger()
                .warning("TicketReminder, handle, sending response");
            context.response(); // Vlad told me that it's allowable but BAD WAY
            // Hence TODO: change this sequence of execution to multi-scheme
            boolean cancel = false;
            for (final ru.yandex.iex.proxy.tickethandlerlegacy.TicketFlight x
                : context.uniqFlights().transferlessFlight())
            {
                switch (x.getFlightType()) {
                    case TicketWidgetType.ETICKET:
                    case "reminder":
                    case "flight":
                        XMessageToLog.info(
                            context,
                            "create-or-update-flight-reminder");
                        /*Object createFlightPost =
                            getCreateOrUpdateFlightReminderPost(x);
                        reminderCreateExecute(
                            createFlightPost,
                            "create-or-update-flight-reminders");*/
                        break;
                    case TicketWidgetType.CHANGING:
                    case TicketWidgetType.CANCELING:
                        XMessageToLog.info(context, "delete-flight-reminder");
                        Object deleteFlightJson = deleteFlightReminders(x);
                        reminderDeleteExecute(
                            deleteFlightJson,
                            "delete-flight-reminders");
                        cancel = true;
                        break;
                    default:
                        XMessageToLog.warning(context, "Unknown type offlight");
                }
                if (cancel) {
                    break;
                }
            }
        } catch (NumberFormatException e) {
            XMessageToLog.error(context, "Check uid mid and other int type", e);
            context.failed(e);
        } catch (Exception e) {
            XMessageToLog.error(context, "Unknown error", e);
            context.failed(e);
        }
    }

    private void reminderDeleteExecute(
        final Object json,
        final String request)
    {
        AsyncClient client = context.iexProxy().reminderClient()
            .adjust(context.session().context());
        try {
            Map<?, ?> js = ValueUtils.asMap(json);
            String fullUrl = context.iexProxy().config()
                .reminderConfig().host().getSchemeName()
                + SCHEME_DELIMITER + context.iexProxy().config()
                    .reminderConfig().host().getHostName()
                + ':' + context.iexProxy().config()
                .reminderConfig().host().getPort() + MAIL_HANDLE + request
                + "?uid=" + js.get(UID)
                + "&ticketId=" + js.get(TicketFlightSet.TICKET_ID);
            XMessageToLog.info(
                context,
                "url: " + fullUrl
                + " json to reminder: " + JsonType.NORMAL.toString(json));
            client.execute(
                context.iexProxy().config().reminderConfig().host(),
                new BasicAsyncRequestProducerGenerator(fullUrl),
                JsonAsyncDomConsumerFactory.OK,
                context.session().listener().createContextGeneratorFor(client),
                new TicketReminderCallback(context));
        } catch (JsonUnexpectedTokenException e) {
            context.iexProxy().logger().log(
                Level.SEVERE,
                "Error when parsing uid or ticketId",
                e);
            context.failed(e);
        }
    }

    private Map<String, Object> deleteFlightReminders(final TicketFlight f) {
        Map<String, Object> reminderFormatJson = new HashMap<String, Object>();
        reminderFormatJson.put(UID, context.uid());
        reminderFormatJson.put(TicketFlightSet.TICKET_ID, f.getTicketId());
        return reminderFormatJson;
    }
}
