package ru.yandex.iex.proxy.tomitahandler;

import java.util.HashMap;
import java.util.Map;

import org.apache.http.HttpException;
import org.apache.http.HttpStatus;

import ru.yandex.http.proxy.ProxySession;
import ru.yandex.iex.proxy.AbstractEntityContext;
import ru.yandex.iex.proxy.IexProxy;
import ru.yandex.iex.proxy.XJsonUtils;
import ru.yandex.json.writer.JsonType;
import ru.yandex.json.xpath.JsonUnexpectedTokenException;

public class TomitaContext extends AbstractEntityContext {
    public static final String E = "e";
    //public static final int MAX_SIZE_OF_PAYLOAD_TO_LOG = 10000;
    private Map<String, Object> flattenedJson = new HashMap<>();
    private Map<String, Object> response = new HashMap<>();
    private String entities = null;

    public TomitaContext(
        final IexProxy iexProxy,
        final ProxySession session,
        final Map<?, ?> json)
        throws HttpException, JsonUnexpectedTokenException
    {
        super(iexProxy, session, json);
        entities = session.params().getOrNull(E);
        XJsonUtils.flattenJson("", json, flattenedJson);
        /* log
        response.put("something", "wrong");
        StringBuilder sbtolog = new StringBuilder();
        sbtolog.append("tomita handle: flattenedJson is ");
        sbtolog.append(JsonType.NORMAL.toString(flattenedJson));
        if (sbtolog.length() > MAX_SIZE_OF_PAYLOAD_TO_LOG) {
            sbtolog.setLength(MAX_SIZE_OF_PAYLOAD_TO_LOG);
            sbtolog.append("...");
        }
        XMessageToLog.info(this, new String(sbtolog));
        */
    }

    public Map<String, Object> getFlattenedJson() {
        return flattenedJson;
    }

    public String getEntities() {
        return entities;
    }

    public void setResponse(final Map<String, Object> jres) {
        response = jres;
    }

    @Override
    public void response() {
        session.response(HttpStatus.SC_OK, JsonType.NORMAL.toString(response));
    }
}
