package ru.yandex.iex.proxy.tomitahandler;

import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

import org.apache.http.HttpException;
import org.apache.http.concurrent.FutureCallback;
import org.apache.http.entity.ContentType;

import ru.yandex.http.proxy.ProxySession;
import ru.yandex.http.util.AbstractFilterFutureCallback;
import ru.yandex.http.util.MultiFutureCallback;
import ru.yandex.http.util.nio.client.AsyncClient;
import ru.yandex.http.util.nio.client.AsyncPostURIRequestProducerSupplier;
import ru.yandex.iex.proxy.AbstractEntityHandler;
import ru.yandex.iex.proxy.IexProxy;
import ru.yandex.iex.proxy.XJsonUtils;
import ru.yandex.json.async.consumer.JsonAsyncDomConsumerFactory;
import ru.yandex.json.xpath.JsonUnexpectedTokenException;

public class TomitaHandler extends AbstractEntityHandler<TomitaContext> {
    public TomitaHandler(final IexProxy iexProxy) {
        super(iexProxy);
    }

    @Override
    protected TomitaContext createContext(
        final IexProxy iexProxy,
        final ProxySession session,
        final Map<?, ?> json)
        throws HttpException, JsonUnexpectedTokenException
    {
        return new TomitaContext(iexProxy, session, json);
    }

    @Override
    protected void handle(final TomitaContext context) {
        final MultiFutureCallback<TomitaResult> multiCallback =
            new MultiFutureCallback<>(
                new FinishMulticallback(context));

        final List<ResultCallback> subCallbacks =
            new ArrayList<>();

        for (
            Map.Entry<String, Object> x
                : context.getFlattenedJson().entrySet())
        {
            String entities = "addr";
            if (context.getEntities() != null) {
                entities = context.getEntities();
            }
            final String uri = iexProxyInstance.config().iexConfig().uri()
                + "?e=" + entities + "&origin=iex-proxy-tomita&time="
                + context.getReceivedDate();
            String postEntity = (String) x.getValue();
            try {
                final AsyncPostURIRequestProducerSupplier post =
                    new AsyncPostURIRequestProducerSupplier(
                        uri,
                        postEntity,
                        ContentType.APPLICATION_JSON);
                subCallbacks.add(
                    new ResultCallback(
                        x.getKey(),
                        post,
                        multiCallback.newCallback()));
            } catch (URISyntaxException e) {
            }
        }
        multiCallback.done();
        final AsyncClient client =
            iexProxyInstance.iexClient()
                .adjust(context.session().context());
        for (final ResultCallback subCallback : subCallbacks) {
            client.execute(
                subCallback.post(),
                JsonAsyncDomConsumerFactory.OK,
                context.session().listener().createContextGeneratorFor(client),
                subCallback);
        }
    }
}

class ResultCallback
    extends AbstractFilterFutureCallback<Object, TomitaResult>
{
    private final FutureCallback<TomitaResult> callback;
    private final AsyncPostURIRequestProducerSupplier post;
    private final String path;

    ResultCallback(
        final String path,
        final AsyncPostURIRequestProducerSupplier post,
        final FutureCallback<TomitaResult> callback)
    {
        super(callback);
        this.path = path;
        this.post = post;
        this.callback = callback;
    }

    @Override
    public void cancelled() {
        callback.completed(null);
    }

    @Override
    public void failed(final Exception e) {
        callback.completed(null);
    }

    @Override
    public void completed(final Object result) {
        callback.completed(new TomitaResult(result, path));
    }

    public AsyncPostURIRequestProducerSupplier post() {
        return post;
    }
}

class TomitaResult {
    private String path;
    private Object response;

    TomitaResult(final Object response, final String path) {
        this.path = path;
        this.response = response;
    }

    public String getPath() {
        return path;
    }

    public Object getResponse() {
        return response;
    }
}

class FinishMulticallback
    implements FutureCallback<List<TomitaResult>>
{
    private final TomitaContext context;

    FinishMulticallback(final TomitaContext context) {
        this.context = context;
    }

    @Override
    public void completed(final List<TomitaResult> results) {
        Map<String, Object> responseFromAllTomitas = new HashMap<>();
        for (final TomitaResult x : results) {
            if (x != null) {
                XJsonUtils.addValueByPath(
                    responseFromAllTomitas,
                    x.getPath(),
                    x.getResponse());
            }
        }
        context.setResponse(responseFromAllTomitas);

        context.response();
    }

    @Override
    public void cancelled() {
        context.response();
    }

    @Override
    public void failed(final Exception e) {
        //context.failed(e);
    }
}
