package ru.yandex.iex.proxy.xiva;

import ru.yandex.http.config.AbstractHttpHostConfigBuilder;
import ru.yandex.parser.config.ConfigException;
import ru.yandex.parser.config.IniConfig;
import ru.yandex.parser.string.NonEmptyValidator;

public abstract class AbstractXivaConfigBuilder
    <T extends AbstractXivaConfigBuilder<T>>
    extends AbstractHttpHostConfigBuilder<T>
    implements XivaConfig
{
    private String token;

    protected AbstractXivaConfigBuilder(final XivaConfig config) {
        super(config);
        token = config.token();
    }

    protected AbstractXivaConfigBuilder(
        final IniConfig config,
        final XivaConfig defaults)
        throws ConfigException
    {
        super(config, defaults);
        token =
            config.get("token", defaults.token(), NonEmptyValidator.INSTANCE);
    }

    @Override
    public String token() {
        return token;
    }
}
