package ru.yandex.iex.proxy.xiva;

import ru.yandex.parser.config.ConfigException;
import ru.yandex.parser.config.IniConfig;

public class XivaConfigBuilder
    extends AbstractXivaConfigBuilder<XivaConfigBuilder>
{
    public XivaConfigBuilder(final XivaConfig config) {
        super(config);
    }

    public XivaConfigBuilder(final IniConfig config)
        throws ConfigException
    {
        super(config, XivaConfigDefaults.INSTANCE);
    }

    public XivaConfigBuilder(final IniConfig config, final XivaConfig defaults)
        throws ConfigException
    {
        super(config, defaults);
    }

    @Override
    public XivaConfigBuilder self() {
        return this;
    }

    public ImmutableXivaConfig build() throws ConfigException {
        return new ImmutableXivaConfig(this);
    }
}
