package ru.yandex.iex.proxy.xutils;

import java.util.HashMap;
import java.util.Locale;
import java.util.Map;

public final class CitiesUtils {
    private static final String[][] RU_2_EN_CITY_MAP = {
        {"москва", "moscow"},
        {"санкт-петербург", "saint petersburg"},
        {"новосибирск", "novosibirsk"},
        {"екатеринбург", "yekaterinburg"},
        {"нижний новгород", "nizhny novgorod"},
        {"самара", "samara"},
        {"омск", "omsk"},
        {"казань", "kazan"},
        {"челябинск", "chelyabinsk"},
        {"ростов-на-дону", "rostov-on-don"},
        {"уфа", "ufa"},
        {"волгоград", "volgograd"},
        {"пермь", "perm"},
        {"красноярск", "krasnoyarsk"},
        {"воронеж", "voronezh"},
        {"саратов", "saratov"},
        {"краснодар", "krasnodar"},
        {"тольятти", "tolyatti"},
        {"ижевск", "izhevsk"},
        {"ульяновск", "ulyanovsk"},
        {"барнаул", "barnaul"},
        {"владивосток", "vladivostok"},
        {"ярославль", "yaroslavl"},
        {"иркутск", "irkutsk"},
        {"тюмень", "tyumen"},
        {"хабаровск", "khabarovsk"},
        {"махачкала", "makhachkala"},
        {"оренбург", "orenburg"},
        {"новокузнецк", "novokuznetsk"},
        {"кемерово", "kemerovo"},
        {"рязань", "ryazan"},
        {"томск", "tomsk"},
        {"астрахань", "astrakhan"},
        {"пенза", "penza"},
        {"набережные Челны", "naberezhnye chelny"},
        {"липецк", "lipetsk"},
        {"тула", "tula"},
        {"киров", "kirov"},
        {"чебоксары", "cheboksary"},
        {"калининград", "kaliningrad"},
        {"брянск", "bryansk"},
        {"курск", "kursk"},
        {"иваново", "ivanovo"},
        {"магнитогорск", "magnitogorsk"},
        {"улан-удэ", "ulan-ude"},
        {"тверь", "tver"},
        {"ставрополь", "stavropol"},
        {"нижний Тагил", "nizhny tagil"},
        {"белгород", "belgorod"},
        {"архангельск", "arkhangelsk"},
        {"владимир", "vladimir"},
        {"сочи", "sochi"},
        {"курган", "kurgan"},
        {"смоленск", "smolensk"},
        {"калуга", "kaluga"},
        {"чита", "chita"},
        {"орёл", "oryol"},
        {"волжский", "volzhsky"},
        {"череповец", "cherepovets"},
        {"владикавказ", "vladikavkaz"},
        {"мурманск", "murmansk"},
        {"сургут", "surgut"},
        {"вологда", "vologda"},
        {"саранск", "saransk"},
        {"тамбов", "tambov"},
        {"стерлитамак", "sterlitamak"},
        {"грозный", "grozny"},
        {"якутск", "yakutsk"},
        {"кострома", "kostroma"},
        {"комсомольск-на-Амуре", "komsomolsk-on-amur"},
        {"петрозаводск", "petrozavodsk"},
        {"таганрог", "taganrog"},
        {"нижневартовск", "nizhnevartovsk"},
        {"йошкар-ола", "yoshkar-ola"},
        {"братск", "bratsk"},
        {"новороссийск", "novorossiysk"},
        {"дзержинск", "dzerzhinsk"},
        {"нальчик", "nalchik"},
        {"шахты", "shakhty"},
        {"орск", "orsk"},
        {"сыктывкар", "syktyvkar"},
        {"нижнекамск", "nizhnekamsk"},
        {"ангарск", "angarsk"},
        {"старый оскол", "stary oskol"},
        {"великий новгород", "veliky novgorod"},
        {"балашиха", "balashikha"},
        {"благовещенск", "blagoveshchensk"},
        {"прокопьевск", "prokopyevsk"},
        {"бийск", "biysk"},
        {"химки", "khimki"},
        {"псков", "pskov"},
        {"энгельс", "engels"},
        {"рыбинск", "rybinsk"},
        {"балаково", "balakovo"},
        {"северодвинск", "severodvinsk"},
        {"армавир", "armavir"},
        {"подольск", "podolsk"},
        {"королёв", "korolyov"},
        {"южно-сахалинск", "yuzhno-sakhalinsk"},
        {"петропавловск-камчатский", "petropavlovsk-kamchatsky"},
        {"сызрань", "syzran"},
        {"норильск", "norilsk"},
        {"златоуст", "zlatoust"},
        {"каменск-уральский", "kamensk-uralsky"},
        {"мытищи", "mytishchi"},
        {"люберцы", "lyubertsy"},
        {"волгодонск", "volgodonsk"},
        {"новочеркасск", "novocherkassk"},
        {"абакан", "abakan"},
        {"находка", "nakhodka"},
        {"уссурийск", "ussuriysk"},
        {"березники", "berezniki"},
        {"салават", "salavat"},
        {"электросталь", "elektrostal"},
        {"миасс", "miass"},
        {"рубцовск", "rubtsovsk"},
        {"альметьевск", "almetyevsk"},
        {"ковров", "kovrov"},
        {"коломна", "kolomna"},
        {"майкоп", "maykop"},
        {"пятигорск", "pyatigorsk"},
        {"одинцово", "odintsovo"},
        {"копейск", "kopeysk"},
        {"новомосковск", "novomoskovsk"},
        {"железнодорожный", "zheleznodorozhny"},
        {"хасавюрт", "khasavyurt"},
        {"черкесск", "cherkessk"},
        {"кисловодск", "kislovodsk"},
        {"серпухов", "serpukhov"},
        {"первоуральск", "pervouralsk"},
        {"новочебоксарск", "novocheboksarsk"},
        {"нефтеюганск", "nefteyugansk"},
        {"димитровград", "dimitrovgrad"},
        {"нефтекамск", "neftekamsk"},
        {"орехово-зуево", "orekhovo-zuyevo"},
        {"камышин", "kamyshin"},
        {"дербент", "derbent"},
        {"невинномысск", "nevinnomyssk"},
        {"красногорск", "krasnogorsk"},
        {"муром", "murom"},
        {"батайск", "bataysk"},
        {"сергиев Посад", "sergiyev posad"},
        {"новошахтинск", "novoshakhtinsk"},
        {"ноябрьск", "noyabrsk"},
        {"щёлково", "shchyolkovo"},
        {"кызыл", "kyzyl"},
        {"октябрьский", "oktyabrsky"},
        {"ачинск", "achinsk"},
        {"северск", "seversk"},
        {"новокуйбышевск", "novokuybyshevsk"},
        {"елец", "yelets"},
        {"арзамас", "arzamas"},
        {"обнинск", "obninsk"},
        {"жуковский", "zhukovsky"},
        {"новый уренгой", "novy urengoy"},
        {"элиста", "elista"},
        {"пушкино", "pushkino"},
        {"артём", "artyom"},
        {"междуреченск", "mezhdurechensk"},
        {"ленинск-кузнецкий", "leninsk-kuznetsky"},
        {"сарапул", "sarapul"},
        {"ессентуки", "yessentuki"},
        {"каспийск", "kaspiysk"},
        {"ногинск", "noginsk"},
        {"тобольск", "tobolsk"},
        {"ухта", "ukhta"},
        {"серов", "serov"},
        {"воткинск", "votkinsk"},
        {"великие луки", "velikiye luki"},
        {"мичуринск", "michurinsk"},
        {"киселёвск", "kiselyovsk"},
        {"новотроицк", "novotroitsk"},
        {"зеленодольск", "zelenodolsk"},
        {"соликамск", "solikamsk"},
        {"бердск", "berdsk"},
        {"раменское", "ramenskoye"},
        {"домодедово", "domodedovo"},
        {"магадан", "magadan"},
        {"глазов", "glazov"},
        {"каменск-шахтинский", "kamensk-shakhtinsky"},
        {"железногорск", "zheleznogorsk"},
        {"канск", "kansk"},
        {"назрань", "nazran"},
        {"гатчина", "gatchina"},
        {"саров", "sarov"},
        {"воскресенск", "voskresensk"},
        {"долгопрудный", "dolgoprudny"},
        {"бугульма", "bugulma"},
        {"кузнецк", "kuznetsk"},
        {"губкин", "gubkin"},
        {"кинешма", "kineshma"},
        {"ейск", "yeysk"},
        {"реутов", "reutov"},
        {"усть-илимск", "ust-ilimsk"},
        {"новоуральск", "novouralsk"},
        {"усолье-сибирское", "usolye-sibirskoye"},
        {"азов", "azov"},
        {"бузулук", "buzuluk"},
        {"чайковский", "chaykovsky"},
        {"балашов", "balashov"},
        {"озёрск", "ozyorsk"},
        {"юрга", "yurga"},
        {"кирово-чепецк", "kirovo-chepetsk"},
        {"кропоткин", "kropotkin"},
        {"клин", "klin"},
        {"ханты-мансийск", "khanty-mansiysk"},
        {"выборг", "vyborg"},
        {"троицк", "troitsk"},
        {"бор", "bor"},
        {"шадринск", "shadrinsk"},
        {"белово", "belovo"},
        {"минеральные воды", "mineralnye vody"},
        {"анжеро-судженск", "anzhero-sudzhensk"},
        {"биробиджан", "birobidzhan"},
        {"лобня", "lobnya"},
        {"чапаевск", "chapayevsk"},
        {"георгиевск", "georgiyevsk"},
        {"черногорск", "chernogorsk"},
        {"минусинск", "minusinsk"},
        {"михайловск", "mikhaylovsk"},
        {"елабуга", "yelabuga"},
        {"дубна", "dubna"},
        {"воркута", "vorkuta"},
        {"новоалтайск", "novoaltaysk"},
        {"егорьевск", "yegoryevsk"},
        {"асбест", "asbest"},
        {"белорецк", "beloretsk"},
        {"белогорск", "belogorsk"},
        {"гуково", "gukovo"},
        {"туймазы", "tuymazy"},
        {"ступино", "stupino"},
        {"кстово", "kstovo"},
        {"вольск", "volsk"},
        {"ишимбай", "ishimbay"},
        {"кунгур", "kungur"},
        {"зеленогорск", "zelenogorsk"},
        {"лысьва", "lysva"},
        {"сосновый Бор", "sosnovy bor"},
        {"борисоглебск", "borisoglebsk"},
        {"ишим", "ishim"},
        {"наро-фоминск", "naro-fominsk"},
        {"будённовск", "budyonnovsk"},
        {"донской", "donskoy"},
        {"полевской", "polevskoy"},
        {"лениногорск", "leninogorsk"},
        {"славянск-на-кубани", "slavyansk-na-kubani"},
        {"павловский посад", "pavlovsky posad"},
        {"заречный", "zarechny"},
        {"туапсе", "tuapse"},
        {"россошь", "rossosh"},
        {"лабинск", "labinsk"},
        {"кумертау", "kumertau"},
        {"сибай", "sibay"},
        {"буйнакск", "buynaksk"},
        {"клинцы", "klintsy"},
        {"ржев", "rzhev"},
        {"ревда", "revda"},
        {"тихорецк", "tikhoretsk"},
        {"нерюнгри", "neryungri"},
        {"алексин", "aleksin"},
        {"александров", "alexandrov"},
        {"мелеуз", "meleuz"},
        {"сальск", "salsk"},
        {"дмитров", "dmitrov"},
        {"лесосибирск", "lesosibirsk"},
        {"гусь-хрустальный", "gus-khrustalny"},
        {"чистополь", "chistopol"},
        {"чехов", "chekhov"},
        {"павлово", "pavlovo"},
        {"котлас", "kotlas"},
        {"белебей", "belebey"},
        {"искитим", "iskitim"},
        {"верхняя пышма", "verkhnyaya pyshma"},
        {"всеволожск", "vsevolozhsk"},
        {"апатиты", "apatity"},
        {"краснотурьинск", "krasnoturyinsk"},
        {"прохладный", "prokhladny"},
        {"михайловка", "mikhaylovka"},
        {"анапа", "anapa"},
        {"свободный", "svobodny"},
        {"ивантеевка", "ivanteyevka"},
        {"шуя", "shuya"},
        {"тихвин", "tikhvin"},
        {"когалым", "kogalym"},
        {"щёкино", "shchyokino"},
        {"крымск", "krymsk"},
        {"вязьма", "vyazma"},
        {"горно-алтайск", "gorno-altaysk"},
        {"видное", "vidnoye"},
        {"арсеньев", "arsenyev"},
        {"выкса", "vyksa"},
        {"климовск", "klimovsk"},
        {"лиски", "liski"},
        {"краснокаменск", "krasnokamensk"},
        {"волжск", "volzhsk"},
        {"избербаш", "izberbash"},
        {"жигулёвск", "zhigulyovsk"},
        {"фрязино", "fryazino"},
        {"узловая", "uzlovaya"},
        {"лыткарино", "lytkarino"},
        {"геленджик", "gelendzhik"},
        {"рославль", "roslavl"},
        {"нягань", "nyagan"},
        {"тимашёвск", "timashyovsk"},
        {"белореченск", "belorechensk"},
        {"боровичи", "borovichi"},
        {"солнечногорск", "solnechnogorsk"},
        {"назарово", "nazarovo"},
        {"черемхово", "cheremkhovo"},
        {"вышний волочёк", "vyshny volochyok"},
        {"кириши", "kirishi"},
        {"краснокамск", "krasnokamsk"},
        {"берёзовский", "beryozovsky"},
        {"балахна", "balakhna"},
        {"лесной", "lesnoy"},
        {"ливны", "livny"},
        {"донецк", "donetsk"},
        {"североморск", "severomorsk"}
    };
    private static final char[] CYR =
        {'a', 'б', 'в', 'г', 'д', 'е', 'ё', 'ж', 'з',
            'и', 'к', 'л', 'м', 'н', 'о', 'п', 'р',
            'с', 'т', 'у', 'ў', 'ф', 'х', 'ц', 'ч',
            'ш', 'щ', 'ы', 'э', 'ю', 'я'};
    private static final String E = "e";
    private static final String[] LAT =
        {"a", "b", "v", "g", "d", E, "jo", "zh", "z",
            "i", "k", "l", "m", "n", "o", "p", "r",
            "s", "t", "u", "w", "f", "h", "ts", "ch",
            "sh", "sch", "", E, "ju", "ja"};
    private static final Map<String, String> LOOKUPRU2ENMAP;
    private static final Map<Character, String> LOOKUPCYR2LAT;

    static {
        LOOKUPRU2ENMAP = new HashMap<>();
        for (final String[] x : RU_2_EN_CITY_MAP) {
            if (x.length == 2) {
                LOOKUPRU2ENMAP.put(
                    x[0].toLowerCase(Locale.getDefault()),
                    x[1].toLowerCase(Locale.getDefault()));
            }
        }
        LOOKUPCYR2LAT = new HashMap<>();
        for (int i = 0; i < CYR.length; ++i) {
            LOOKUPCYR2LAT.put(CYR[i], LAT[i]);
        }
    }

    private CitiesUtils() {
    }

    public static String ru2en(final String ruCity) {
        String cityLowercased = ruCity.toLowerCase(Locale.getDefault());
        String res = LOOKUPRU2ENMAP.get(cityLowercased);
        if (res != null) {
            res = res.toLowerCase(Locale.getDefault());
        } else {
            res = translit(ruCity);
        }
        if (res.contains(" ")) {
            StringBuilder sb = new StringBuilder();
            sb.append('"');
            sb.append(res);
            sb.append('"');
            res = new String(sb);
        }
        return res;
    }

    private static String translit(final String city) {
        StringBuilder sb = new StringBuilder();
        for (Character x : city.toCharArray()) {
            String s = LOOKUPCYR2LAT.get(x);
            if (s != null) {
                sb.append(LOOKUPCYR2LAT.get(x));
            } else {
                sb.append(x);
            }
        }
        return new String(sb);
    }
}
