package ru.yandex.iex.proxy.xutils;

import java.util.HashSet;

public final class HashUtils {
    public static final int MIN_HASH_LENGTH = 6;
    private static final Character[] VOWELS =
    {
        'a', 'e', 'i', 'o', 'u', // en
        'а', 'и', 'о', 'у', 'ы', 'э', // ru
        'е', 'ё', 'ю', 'я' // ru
    };

    private static final HashSet<Character> HVOWELS;

    static {
        HVOWELS = new HashSet<Character>();
        for (final Character x : VOWELS) {
            HVOWELS.add(x);
        }
    }

    private HashUtils() {
    }

    public static boolean isProbableStringHash(final String str) {
        return str.length() >= MIN_HASH_LENGTH && !isProbableHumanWord(str);
    }

    public static boolean isProbableHumanWord(final String str) {
        if (str.isEmpty()) {
            return false;
        }
        int n = str.length();
        int diffSounds = 0;
        for (int i = 1; i < n; ++i) {
            int fc = getSpeechSoundCode(str.charAt(i - 1));
            int sc = getSpeechSoundCode(str.charAt(i));
            diffSounds += Math.abs(fc - sc);
        }
        return diffSounds >= n / 2;
    }

    public static boolean isUrlContainsHash(final String url) {
        String[] words = splitUrlIntoWords(url);
        for (int i = 0; i < words.length; ++i) {
            if (isProbableStringHash(words[i])) {
                return true;
            }
        }
        return false;
    }

    private static boolean isVowel(final char ch) {
        return HVOWELS.contains(Character.toLowerCase(ch));
    }

//    private static boolean isConsonant(final char ch) {
//        return !isVowel(ch);
//    }

    private static int getSpeechSoundCode(final char ch) {
        int code = 0;
        if (isVowel(ch)) {
            code = 1;
        }
        return code;
    }

    private static String[] splitUrlIntoWords(final String url) {
        String[] result = url.split("[/=?\\-\\\\.&;:%\\\\[\\\\]@!$'()*+,]");
        return result;
    }
}
