package ru.yandex.iex.proxy.xutils;

import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.Map;

import ru.yandex.iex.proxy.XRegexpUtils;

public final class PriceFormat {
    public static final int FORMAT_LEN = 3;
    public static final double MAX_ESHOP_PRICE = 999999;

    private PriceFormat() {
    }

    public static Map.Entry<String, String> extractPriceAndCurrency(
        final String rawPrice,
        final String defaultCurrency)
    {
        String formattedPrice;
        String formattedCurrency = "";
        ArrayList<String> prices =
            XRegexpUtils.getPrices(rawPrice);
        ArrayList<String> curr =
            XRegexpUtils.getCurrencies(rawPrice);
        if (!prices.isEmpty()) {
            formattedPrice = PriceFormat.format(prices.get(0));
        } else {
            formattedPrice = PriceFormat.format(rawPrice);
        }
        if (!curr.isEmpty()) {
            formattedCurrency = curr.get(0);
        }
        double val = PriceFormat.getPriceValue(formattedPrice);
        if (val <= 0.0 || val > PriceFormat.MAX_ESHOP_PRICE) {
            formattedPrice = "";
        }
        if (formattedCurrency.isEmpty() && defaultCurrency != null) {
            formattedCurrency = defaultCurrency;
        }
        return new AbstractMap.SimpleEntry<>(formattedPrice, formattedCurrency);
    }

    public static String format(final String price) {
        String p = sanitize(price);
        ArrayList<String> prices = XRegexpUtils.getDoubles(p);
        prices.addAll(XRegexpUtils.getDoubles2(p));
        prices.addAll(XRegexpUtils.getStrInts(p));
        if (!prices.isEmpty()) {
            String firstp = prices.get(0); // ignore rest numbers
            String[] dted = firstp.split("[,.]");
            StringBuilder res = new StringBuilder();
            if (dted.length > 0) {
                int len = dted[0].length();
                int curLen = len;
                for (char x : dted[0].toCharArray()) {
                    if (curLen != len && curLen % FORMAT_LEN == 0) {
                        res.append(' ');
                    }
                    res.append(x);
                    --curLen;
                }
            }
            if (dted.length > 1) {
                res.append('.');
                res.append(dted[1]);
            }
            return new String(res);
        }
        return "0";
    }

    public static Double getPriceValue(final String price) {
        String sed = sanitize(price).replace(",", ".");
        double val = 0.0;
        try {
            val = Double.valueOf(sed);
        } catch (NumberFormatException e) {
        }
        return val;
    }

    public static String normalizeCurrency(final String curr) {
        if (XRegexpUtils.isRuCurrency(curr)) {
            return "руб.";
        }
        return curr;
    }

    private static String sanitize(final String price) {
        StringBuilder sb = new StringBuilder();
        for (char x : price.toCharArray()) {
            if (Character.isDigit(x) || x == ',' || x == '.') {
                sb.append(x);
            }
        }
        return new String(sb);
    }
}
