package ru.yandex.iex.proxy.xutils;

import java.io.IOException;
import java.io.StringReader;
import java.util.Map;

import org.xml.sax.SAXException;

import ru.yandex.io.StringBuilderWriter;
import ru.yandex.parser.html.BodyContentHandler;
import ru.yandex.parser.html.TextContentHandler;
import ru.yandex.parser.html.generated.HtmlProcessor;

public final class SanitizeUtils {
    private SanitizeUtils() {
    }

    public static String sanitizeHtmlString(final String s) {
        StringBuilderWriter sbw = new StringBuilderWriter();
        HtmlProcessor htmlSanitizer =
            new HtmlProcessor(
                new BodyContentHandler(
                    new TextContentHandler(sbw)));
        try {
            htmlSanitizer.process(new StringReader(s));
        } catch (IOException e) {
        } catch (SAXException e) {
        }
        return sbw.toString();
    }

    public static void sanitizeHtmlValueOfFlatMap(final Map<String, Object> x) {
        for (final Map.Entry<String, Object> ex : x.entrySet()) {
            Object v = ex.getValue();
            if (v instanceof String) {
                x.replace(ex.getKey(), sanitizeHtmlString((String) v));
            }
        }
    }
}
