package ru.yandex.iex.proxy.xutils.mailsender;

import java.util.Set;

import ru.yandex.iex.proxy.AbstractEntityContext;
import ru.yandex.parser.email.types.MessageType;

public abstract class AbstractSendmailContext {
    private final AbstractEntityContext context;
    private final String to;
    private final String subject;
    private final Set<MessageType> types;
    private final String from;
    private final String mid;
    private final String uid;

    AbstractSendmailContext(
        final AbstractEntityContext context,
        final String to)
    {
        this.context = context;
        this.to = to;
        subject = context.getSubject();
        types = context.getTypes();
        from = context.getFrom();
        mid = context.getMid();
        uid = context.uid();
    }

    AbstractEntityContext changeContext() {
        return context;
    }

    public String getUid() {
        return uid;
    }

    public String getMid() {
        return mid;
    }

    public Set<MessageType> getTypes() {
        return types;
    }

    public String getFrom() {
        return from;
    }

    public String getSubject() {
        return subject;
    }

    public String getTo() {
        return to;
    }
}
