package ru.yandex.iex.proxy.xutils.mailsender;

import org.apache.http.HttpHost;

import ru.yandex.http.util.nio.AsyncStringConsumerFactory;
import ru.yandex.http.util.nio.BasicAsyncRequestProducerGenerator;
import ru.yandex.http.util.nio.client.AsyncClient;

public class BasicMailSender implements MailSender {
    @Override
    public void send(final SendmailContext context) {
        String sub = context.changeContext().getSubject();
        if (sub.matches(".*[0-9]+_[0-9]+_iex-proxy")) {
            return;
        }
        AsyncClient client =
            context.changeContext().iexProxy().gettextClient().adjust(
                context.changeContext().session().context());
        HttpHost host =
            context.changeContext().iexProxy().config().gettextConfig().host();
        String uri = "/get-text?mid="
            + context.getMid() + "&uid=" + context.getUid();
        client.execute(
            host,
            new BasicAsyncRequestProducerGenerator(uri),
            AsyncStringConsumerFactory.OK,
            context.changeContext().session().listener()
                .createContextGeneratorFor(client),
            new GettextCallback(context));
    }
}
