package ru.yandex.iex.proxy.xutils.mailsender;

import java.nio.charset.StandardCharsets;
import java.util.logging.Level;

import org.apache.http.concurrent.FutureCallback;
import org.apache.http.entity.ContentType;

import ru.yandex.http.util.BadRequestException;
import ru.yandex.http.util.nio.BasicAsyncRequestProducerGenerator;
import ru.yandex.http.util.nio.EmptyAsyncConsumerFactory;
import ru.yandex.http.util.nio.client.AsyncClient;
import ru.yandex.iex.proxy.xutils.replace.EmailReplacer;
import ru.yandex.iex.proxy.xutils.replace.HrefReplacer;
import ru.yandex.iex.proxy.xutils.replace.NameReplacer;
import ru.yandex.iex.proxy.xutils.replace.PhoneReplacer;
import ru.yandex.logger.PrefixedLogger;
import ru.yandex.parser.email.types.MessageTypeToString;
import ru.yandex.parser.uri.QueryConstructor;

public class GettextCallback implements FutureCallback<Object> {
    private SendmailContext context;

    public GettextCallback(final SendmailContext context) {
        this.context = context;
    }

    @Override
    public void cancelled() {
    }

    @Override
    public void failed(final Exception e) {
        context.changeContext().session().logger().log(
            Level.WARNING,
            "Forwarder: Get text request failed",
            e);
    }

    @Override
    public void completed(final Object result) {
        String postEntity = (String) result;
        postEntity = HrefReplacer.getInstance().replace(postEntity);
        postEntity = PhoneReplacer.getInstance().replace(postEntity);
        postEntity = EmailReplacer.getInstance().replace(postEntity);
        postEntity = NameReplacer.getInstance().replace(postEntity);

        String subject =
            NameReplacer.getInstance().replace(context.getSubject())
                + ' ' + context.getMid() + '_' + context.getUid()
                + "_iex-proxy";
        try {
            QueryConstructor qc = new QueryConstructor("/send-mail?");
            qc.append("from", context.getFrom());
            qc.append("to", context.getTo());
            qc.append("subject", subject);
            qc.append(
                "types",
                MessageTypeToString.INSTANCE.joinCodes(
                    context.getTypes(),
                    ","));

            BasicAsyncRequestProducerGenerator generator =
                new BasicAsyncRequestProducerGenerator(
                    qc.toString(),
                    postEntity.getBytes(StandardCharsets.UTF_8),
                    ContentType.TEXT_HTML);

            AsyncClient client =
                context.changeContext().iexProxy().gatemailClient().adjust(
                    context.changeContext().session().context());
            client.execute(
                context.changeContext().iexProxy().config()
                    .gatemailConfig().host(),
                generator,
                EmptyAsyncConsumerFactory.NON_FATAL,
                context.changeContext()
                    .session().listener().createContextGeneratorFor(client),
                new LoggingSendMailCallback(
                    context.changeContext().session().logger()));
        } catch (BadRequestException e) {
            context.changeContext().session().logger().log(
                Level.WARNING,
                "Forwarder: Failed to construct sendmail context",
                e);
        }
    }

    private static final class LoggingSendMailCallback
        implements FutureCallback<Object>
    {
        private final PrefixedLogger logger;

        private LoggingSendMailCallback(final PrefixedLogger logger) {
            this.logger = logger;
        }

        @Override
        public void completed(final Object o) {
            logger.fine("Mail forwarded");
        }

        @Override
        public void failed(final Exception e) {
            logger.log(
                Level.WARNING,
                "Forwarder: sendmail failed",
                e);
        }

        @Override
        public void cancelled() {
        }
    }
}
